/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.parser.jruby;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.visitor.AbstractNodeVisitor;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.InvalidSourcePosition;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.CheckArityNode;
import org.jruby.truffle.language.arguments.CheckKeywordArityNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.methods.Arity;

public abstract class Translator
extends AbstractNodeVisitor<RubyNode> {
    public static final Set<String> ALWAYS_DEFINED_GLOBALS = new HashSet<String>(Arrays.asList("$~", "$!"));
    public static final Set<String> FRAME_LOCAL_GLOBAL_VARIABLES = new HashSet<String>(Arrays.asList("$_", "$+", "$&", "$`", "$'"));
    protected final Node currentNode;
    protected final RubyContext context;
    protected final Source source;
    protected Deque<SourceSection> parentSourceSection = new ArrayDeque<SourceSection>();

    public Translator(Node currentNode, RubyContext context, Source source) {
        this.currentNode = currentNode;
        this.context = context;
        this.source = source;
    }

    public static RubyNode sequence(RubyContext context, SourceSection sourceSection, List<RubyNode> sequence) {
        List<RubyNode> flattened = Translator.flatten(context, sequence, true);
        if (flattened.isEmpty()) {
            return new NilLiteralNode(context, sourceSection, true);
        }
        if (flattened.size() == 1) {
            return flattened.get(0);
        }
        RubyNode[] flatSequence = flattened.toArray(new RubyNode[flattened.size()]);
        return new SequenceNode(context, Translator.enclosing(sourceSection, flatSequence), flatSequence);
    }

    public static SourceSection enclosing(SourceSection base, SourceSection ... sourceSections) {
        for (SourceSection sourceSection : sourceSections) {
            if (base != null) break;
            base = sourceSection;
        }
        if (base == null) {
            return null;
        }
        if (base.getSource() == null) {
            return base;
        }
        if (sourceSections.length == 0) {
            return base;
        }
        int startLine = base.getStartLine();
        int endLine = base.getEndLine();
        for (SourceSection sourceSection : sourceSections) {
            if (sourceSection == null) continue;
            startLine = Math.min(startLine, sourceSection.getStartLine());
            int nodeEndLine = sourceSection.getSource() == null ? sourceSection.getStartLine() : sourceSection.getEndLine();
            endLine = Math.max(endLine, nodeEndLine);
        }
        int index = base.getSource().getLineStartOffset(startLine);
        int length = 0;
        for (int n = startLine; n <= endLine; ++n) {
            length += base.getSource().getLineLength(n) + 1;
        }
        length = Math.min(length, base.getSource().getLength() - index);
        length = Math.max(0, length);
        return base.getSource().createSection(base.getIdentifier(), index, length);
    }

    public static SourceSection enclosing(SourceSection base, RubyNode[] sequence) {
        SourceSection[] sourceSections = new SourceSection[sequence.length];
        for (int n = 0; n < sequence.length; ++n) {
            sourceSections[n] = sequence[n].getEncapsulatingSourceSection();
        }
        return Translator.enclosing(base, sourceSections);
    }

    private static List<RubyNode> flatten(RubyContext context, List<RubyNode> sequence, boolean allowTrailingNil) {
        ArrayList<RubyNode> flattened = new ArrayList<RubyNode>();
        for (int n = 0; n < sequence.size(); ++n) {
            boolean lastNode = n == sequence.size() - 1;
            RubyNode node = sequence.get(n);
            if (node instanceof NilLiteralNode && ((NilLiteralNode)node).isImplicit()) {
                if (!allowTrailingNil || !lastNode) continue;
                flattened.add(node);
                continue;
            }
            if (node instanceof SequenceNode) {
                flattened.addAll(Translator.flatten(context, Arrays.asList(((SequenceNode)node).getSequence()), lastNode));
                continue;
            }
            flattened.add(node);
        }
        return flattened;
    }

    protected SourceSection translate(ISourcePosition sourcePosition) {
        return this.translate(this.source, sourcePosition, this.getIdentifier());
    }

    protected SourceSection translate(ISourcePosition sourcePosition, String identifier) {
        return this.translate(this.source, sourcePosition, identifier);
    }

    private SourceSection translate(Source source, ISourcePosition sourcePosition, String identifier) {
        if (sourcePosition == InvalidSourcePosition.INSTANCE) {
            if (this.parentSourceSection.peek() == null) {
                throw new UnsupportedOperationException("Truffle doesn't want invalid positions - find a way to give me a real position!");
            }
            return this.parentSourceSection.peek();
        }
        return source.createSection(identifier, sourcePosition.getLine() + 1);
    }

    protected RubyNode nilNode(SourceSection sourceSection) {
        return new NilLiteralNode(this.context, sourceSection, false);
    }

    protected RubyNode translateNodeOrNil(SourceSection sourceSection, org.jruby.ast.Node node) {
        RubyNode rubyNode = node != null ? (RubyNode)node.accept((NodeVisitor)this) : this.nilNode(sourceSection);
        return rubyNode;
    }

    protected abstract String getIdentifier();

    public static RubyNode createCheckArityNode(RubyContext context, SourceSection sourceSection, Arity arity) {
        if (!arity.acceptsKeywords()) {
            return new CheckArityNode(arity);
        }
        return new CheckKeywordArityNode(context, sourceSection, arity);
    }

    protected void setSourceSection(RubyNode node, SourceSection sourceSection) {
        node.unsafeSetSourceSection(sourceSection);
    }
}

