/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.awt.peer.CanvasPeer;
import javax.swing.JComponent;
import sun.awt.CGraphicsConfig;
import sun.lwawt.LWComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWCanvasPeer
extends LWComponentPeer<Component, JComponent>
implements CanvasPeer {
    private VolatileImage backBuffer;

    LWCanvasPeer(Canvas canvas, PlatformComponent platformComponent) {
        super(canvas, platformComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) {
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        VolatileImage volatileImage = cGraphicsConfig.createBackBufferImage((Component)this.getTarget(), 0L);
        Object object = this.getStateLock();
        synchronized (object) {
            this.backBuffer = volatileImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getBackBuffer() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.backBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        VolatileImage volatileImage = (VolatileImage)this.getBackBuffer();
        if (volatileImage == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        Graphics graphics = this.getGraphics();
        try {
            graphics.drawImage(volatileImage, n, n2, n3, n4, n, n2, n3, n4, null);
        }
        finally {
            graphics.dispose();
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            Graphics2D graphics2D = (Graphics2D)volatileImage.getGraphics();
            try {
                graphics2D.setBackground(this.getBackground());
                graphics2D.clearRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyBuffers() {
        Image image = this.getBackBuffer();
        if (image != null) {
            Object object = this.getStateLock();
            synchronized (object) {
                if (image == this.backBuffer) {
                    this.backBuffer = null;
                }
            }
            image.flush();
        }
    }

    @Override
    public GraphicsConfiguration getAppropriateGraphicsConfiguration(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration;
    }
}

