/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class UnclosedWays
extends Test {
    private final UnclosedWaysCheck[] checks = new UnclosedWaysCheck[]{new UnclosedWaysCheck(1101, "natural", I18n.marktr("natural type {0}"), new HashSet<String>(Arrays.asList("cave", "coastline", "cliff", "tree_row", "ridge", "valley", "arete", "gorge"))), new UnclosedWaysCheck(1102, "landuse", I18n.marktr("landuse type {0}")), new UnclosedWaysCheck(1103, "amenities", I18n.marktr("amenities type {0}")), new UnclosedWaysCheck(1104, "sport", I18n.marktr("sport type {0}"), new HashSet<String>(Arrays.asList("water_slide", "climbing"))), new UnclosedWaysCheck(1105, "tourism", I18n.marktr("tourism type {0}"), new HashSet<String>(Arrays.asList("attraction", "artwork"))), new UnclosedWaysCheck(1106, "shop", I18n.marktr("shop type {0}")), new UnclosedWaysCheck(1107, "leisure", I18n.marktr("leisure type {0}"), new HashSet<String>(Arrays.asList("track", "slipway"))), new UnclosedWaysCheck(1108, "waterway", I18n.marktr("waterway type {0}"), new HashSet<String>(Arrays.asList("riverbank")), false), new UnclosedWaysCheck(1109, "boundary", I18n.marktr("boundary type {0}")), new UnclosedWaysBooleanCheck(1120, "building", I18n.marktr("building")), new UnclosedWaysBooleanCheck(1130, "area", I18n.marktr("area"))};

    public UnclosedWays() {
        super(I18n.tr("Unclosed Ways", new Object[0]), I18n.tr("This tests if ways which should be circular are closed.", new Object[0]));
    }

    public Set<String> getCheckedKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        for (UnclosedWaysCheck unclosedWaysCheck : this.checks) {
            hashSet.add(unclosedWaysCheck.key);
        }
        return hashSet;
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable() || way.isArea()) {
            return;
        }
        for (OsmPrimitive osmPrimitive : way.getReferrers()) {
            if (!(osmPrimitive instanceof Relation) || !((Relation)osmPrimitive).isMultipolygon()) continue;
            return;
        }
        for (UnclosedWaysCheck unclosedWaysCheck : this.checks) {
            TestError testError = unclosedWaysCheck.getTestError(way);
            if (testError == null) continue;
            this.errors.add(testError);
            return;
        }
    }

    private final class UnclosedWaysBooleanCheck
    extends UnclosedWaysCheck {
        UnclosedWaysBooleanCheck(int n, String string, String string2) {
            super(n, string, string2);
        }

        @Override
        protected boolean isValueErroneous(String string) {
            Boolean bl = OsmUtils.getOsmBoolean(string);
            return bl != null && bl != false || bl == null && string != null;
        }
    }

    private class UnclosedWaysCheck {
        public final int code;
        public final String key;
        private final String engMessage;
        private final Set<String> specialValues;
        private final boolean ignore;

        UnclosedWaysCheck(int n, String string, String string2) {
            this(n, string, string2, Collections.emptySet());
        }

        UnclosedWaysCheck(int n, String string, String string2, Set<String> set) {
            this(n, string, string2, set, true);
        }

        UnclosedWaysCheck(int n, String string, String string2, Set<String> set, boolean bl) {
            this.code = n;
            this.key = string;
            this.engMessage = string2;
            this.specialValues = set;
            this.ignore = bl;
        }

        public final TestError getTestError(Way way) {
            String string = way.get(this.key);
            if (this.isValueErroneous(string)) {
                String string2 = this.engMessage.contains("{0}") ? I18n.tr(this.engMessage, I18n.tr(string, new Object[0])) : I18n.tr(this.engMessage, new Object[0]);
                String string3 = this.engMessage.contains("{0}") ? MessageFormat.format(this.engMessage, string) : this.engMessage;
                return new TestError(UnclosedWays.this, Severity.WARNING, I18n.tr("Unclosed way", new Object[0]), string2, string3, this.code, Arrays.asList(way), Arrays.asList(way.firstNode(), way.lastNode()));
            }
            return null;
        }

        protected boolean isValueErroneous(String string) {
            return string != null && this.ignore != this.specialValues.contains(string);
        }
    }
}

