/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.OopField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ProtectionDomainEntry
extends VMObject {
    private static AddressField nextField;
    private static OopField protectionDomainField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ProtectionDomainEntry");
        nextField = type.getAddressField("_next");
        protectionDomainField = type.getOopField("_protection_domain");
    }

    public ProtectionDomainEntry(Address addr) {
        super(addr);
    }

    public ProtectionDomainEntry next() {
        return (ProtectionDomainEntry)VMObjectFactory.newObject(ProtectionDomainEntry.class, this.addr);
    }

    public Oop protectionDomain() {
        return VM.getVM().getObjectHeap().newOop(protectionDomainField.getValue(this.addr));
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ProtectionDomainEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

