/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;
import sun.jvm.hotspot.asm.sparc.V9InstructionDecoder;
import sun.jvm.hotspot.utilities.Assert;

abstract class V9CMoveDecoder
extends InstructionDecoder
implements V9InstructionDecoder {
    private static final String[] iccConditionNames = new String[]{"n", "e", "le", "l", "leu", "cs", "neg", "vs", "a", "ne", "g", "ge", "gu", "cc", "pos", "vc"};
    private static final String[] fccConditionNames = new String[]{"fn", "fne", "flg", "ful", "fl", "fug", "fg", "fu", "fa", "fe", "fue", "fge", "fuge", "fle", "fule", "fo"};

    V9CMoveDecoder() {
    }

    static String getConditionName(int conditionCode, int conditionFlag) {
        return conditionFlag == 4 || conditionFlag == 6 ? iccConditionNames[conditionCode] : fccConditionNames[conditionCode];
    }

    static int getMoveConditionCode(int instruction) {
        return (instruction & 0x3C000) >>> 14;
    }

    static int getRegisterConditionCode(int instruction) {
        return (instruction & 0x1C00) >>> 10;
    }

    static ImmediateOrRegister getCMoveSource(int instruction, int numBits) {
        ImmediateOrRegister source = null;
        source = V9CMoveDecoder.isIBitSet(instruction) ? new Immediate(new Short((short)V9CMoveDecoder.extractSignedIntFromNBits(instruction, numBits))) : SPARCRegisters.getRegister(V9CMoveDecoder.getSourceRegister2(instruction));
        return source;
    }

    static String getFloatTypeCode(int dataType) {
        String result = null;
        switch (dataType) {
            case 10: {
                result = "s";
                break;
            }
            case 11: {
                result = "d";
                break;
            }
            case 13: {
                result = "q";
                break;
            }
            default: {
                if (!Assert.ASSERTS_ENABLED) break;
                Assert.that(false, "should not reach here");
            }
        }
        return result;
    }
}

