/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class ClassLoaderHelper {
    private ClassLoaderHelper() {
    }

    static File mapAlternativeName(final File file) {
        List<String> list;
        File file2;
        if (file.getName().endsWith(".so") && (file2 = file.getParentFile()) != null && (list = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                String[] stringArray = file2.list(new LibraryFileFilter(file.getName()));
                if (stringArray == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(stringArray);
            }
        })) != null && list.size() > 0) {
            String string = Collections.max(list, new LibraryFileVersionComparator());
            return new File(file2, string);
        }
        return null;
    }

    private static class LibraryFileVersionComparator
    implements Comparator<String> {
        private LibraryFileVersionComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            String[] stringArray;
            String[] stringArray2 = string.split("\\.");
            int n = this.compareComponents(stringArray2[stringArray2.length - 2], (stringArray = string2.split("\\."))[stringArray.length - 2]);
            if (n == 0) {
                n = this.compareComponents(stringArray2[stringArray2.length - 1], stringArray[stringArray.length - 1]);
            }
            return n;
        }

        int compareComponents(String string, String string2) {
            return Long.valueOf(string).compareTo(Long.valueOf(string2));
        }
    }

    private static class LibraryFileFilter
    implements FilenameFilter {
        final String libname;

        LibraryFileFilter(String string) {
            this.libname = string;
        }

        @Override
        public boolean accept(File file, String string) {
            if (string.startsWith(this.libname)) {
                return string.substring(this.libname.length()).matches("\\.[0-9]{1,20}\\.[0-9]{1,20}$");
            }
            return false;
        }
    }
}

