/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupLoad;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountDupLoadVisitor {
    private DupStore dupStore;
    private int counter;

    public CountDupLoadVisitor() {
        this.init(null);
    }

    public void init(DupStore dupStore) {
        this.dupStore = dupStore;
        this.counter = 0;
    }

    public void visit(Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                this.visit(((ArrayLength)instruction).arrayref);
                break;
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                this.visit(asi.arrayref);
                this.visit(asi.indexref);
                this.visit(asi.valueref);
                break;
            }
            case 191: {
                this.visit(((AThrow)instruction).value);
                break;
            }
            case 266: {
                this.visit(((UnaryOperatorInstruction)instruction).value);
                break;
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                this.visit(boi.value1);
                this.visit(boi.value2);
                break;
            }
            case 192: {
                this.visit(((CheckCast)instruction).objectref);
                break;
            }
            case 54: 
            case 58: 
            case 269: {
                this.visit(((StoreInstruction)instruction).valueref);
                break;
            }
            case 264: {
                this.visit(((DupStore)instruction).objectref);
                break;
            }
            case 275: 
            case 276: {
                this.visit(((ConvertInstruction)instruction).value);
                break;
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                this.visit(ifCmp.value1);
                this.visit(ifCmp.value2);
                break;
            }
            case 260: 
            case 262: {
                this.visit(((IfInstruction)instruction).value);
                break;
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    this.visit(branchList.get(i));
                    --i;
                }
                break;
            }
            case 193: {
                this.visit(((InstanceOf)instruction).objectref);
                break;
            }
            case 182: 
            case 183: 
            case 185: {
                this.visit(((InvokeNoStaticInstruction)instruction).objectref);
            }
            case 184: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    this.visit(list.get(i));
                    --i;
                }
                break;
            }
            case 274: {
                List list = ((InvokeNew)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    this.visit((Instruction)list.get(i));
                    --i;
                }
                break;
            }
            case 171: {
                this.visit(((LookupSwitch)instruction).key);
                break;
            }
            case 194: {
                this.visit(((MonitorEnter)instruction).objectref);
                break;
            }
            case 195: {
                this.visit(((MonitorExit)instruction).objectref);
                break;
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    this.visit(dimensions[i]);
                    --i;
                }
                break;
            }
            case 188: {
                this.visit(((NewArray)instruction).dimension);
                break;
            }
            case 189: {
                this.visit(((ANewArray)instruction).dimension);
                break;
            }
            case 87: {
                this.visit(((Pop)instruction).objectref);
                break;
            }
            case 181: {
                PutField putField = (PutField)instruction;
                this.visit(putField.objectref);
                this.visit(putField.valueref);
                break;
            }
            case 179: {
                this.visit(((PutStatic)instruction).valueref);
                break;
            }
            case 273: {
                this.visit(((ReturnInstruction)instruction).valueref);
                break;
            }
            case 170: {
                this.visit(((TableSwitch)instruction).key);
                break;
            }
            case 280: {
                this.visit(((TernaryOpStore)instruction).objectref);
                break;
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                this.visit(to.value1);
                this.visit(to.value2);
                break;
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                this.visit(ai.value1);
                this.visit(ai.value2);
                break;
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                this.visit(ali.arrayref);
                this.visit(ali.indexref);
                break;
            }
            case 277: 
            case 278: {
                this.visit(((IncInstruction)instruction).value);
                break;
            }
            case 180: {
                this.visit(((GetField)instruction).objectref);
                break;
            }
            case 263: {
                if (((DupLoad)instruction).dupStore != this.dupStore) break;
                ++this.counter;
                break;
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                this.visit(iai.newArray);
                if (iai.values == null) break;
                this.visit(iai.values);
                break;
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                if (ff.init != null) {
                    this.visit(ff.init);
                }
                if (ff.inc != null) {
                    this.visit(ff.inc);
                }
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction test = ((FastTestList)instruction).test;
                if (test != null) {
                    this.visit(test);
                }
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).instructions;
                if (instructions == null) break;
                this.visit(instructions);
                break;
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                this.visit(ffe.variable);
                this.visit(ffe.values);
                this.visit(ffe.instructions);
                break;
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                this.visit(ft2l.test);
                this.visit(ft2l.instructions);
                this.visit(ft2l.instructions2);
                break;
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                if (fi.instruction == null) break;
                this.visit(fi.instruction);
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                this.visit(fs.test);
                FastSwitch.Pair[] pairs = fs.pairs;
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null) {
                        this.visit(instructions);
                    }
                    --i;
                }
                break;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                this.visit(ft.instructions);
                if (ft.finallyInstructions != null) {
                    this.visit(ft.finallyInstructions);
                }
                List<FastTry.FastCatch> catchs = ft.catches;
                int i = catchs.size() - 1;
                while (i >= 0) {
                    this.visit(catchs.get((int)i).instructions);
                    --i;
                }
                break;
            }
            case 319: {
                FastSynchronized fsd = (FastSynchronized)instruction;
                this.visit(fsd.monitor);
                this.visit(fsd.instructions);
                break;
            }
            case 320: {
                FastLabel fl = (FastLabel)instruction;
                if (fl.instruction == null) break;
                this.visit(fl.instruction);
                break;
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                if (fd.instruction == null) break;
                this.visit(fd.instruction);
                break;
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 25: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 268: 
            case 270: 
            case 279: 
            case 285: {
                break;
            }
            default: {
                System.err.println("Can not count DupLoad in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
            }
        }
    }

    private void visit(List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            this.visit(instructions.get(i));
            --i;
        }
    }

    public int getCounter() {
        return this.counter;
    }
}

