/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.docprovider.formatters.formatters;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.ReplacingTextFormatter;

public class ManFormatter
extends ReplacingTextFormatter {
    public static final String SUFFIX = "1";

    @Override
    public String getNewLine() {
        return PlainTextFormatter.getLineSeparator() + ".br" + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getBoldOpening() {
        return PlainTextFormatter.getLineSeparator() + ".B ";
    }

    @Override
    public String getBoldClosing() {
        return PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getBreakAndBold() {
        return PlainTextFormatter.getLineSeparator() + ".br" + PlainTextFormatter.getLineSeparator() + ".B ";
    }

    @Override
    public String getCloseBoldAndBreak() {
        return PlainTextFormatter.getLineSeparator() + ".B " + PlainTextFormatter.getLineSeparator() + ".br" + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getBoldCloseNwlineBoldOpen() {
        return PlainTextFormatter.getLineSeparator() + ".br" + PlainTextFormatter.getLineSeparator() + ".B ";
    }

    @Override
    public String getTitle(String name) {
        return ".SH " + this.localizeTitle(name) + PlainTextFormatter.getLineSeparator() + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getHeaders(String id, String encoding) {
        return ".TH " + id + " 1 \"" + this.getManPageDate(true) + "\"" + " \"" + "icedtea-web" + " " + this.getVersion() + "\"" + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getTail() {
        return "";
    }

    private String getManPageDate(boolean localize) {
        String month;
        Date now = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(now);
        int day = c.get(5);
        int year = c.get(1);
        if (localize) {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM");
            month = formatter.format((Object)now);
        } else {
            month = this.getUnlocallizedMonth(c.get(2));
        }
        return day + " " + month + " " + year;
    }

    private String getUnlocallizedMonth(int get) {
        switch (get) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
            case 11: {
                return "Dec";
            }
        }
        return "Unkw";
    }

    @Override
    public String getSeeAlso(String s) {
        return ".BR " + s + " (1)" + PlainTextFormatter.getLineSeparator();
    }

    @Override
    public String getFileSuffix() {
        return ".1";
    }

    @Override
    public String wrapParagraph(String s) {
        return PlainTextFormatter.getLineSeparator() + ".PP" + PlainTextFormatter.getLineSeparator() + s;
    }

    @Override
    public String getOption(String key, String value) {
        if (key.startsWith("-")) {
            key = "\\" + key;
        }
        if (value.startsWith("-")) {
            value = "\\" + value;
        }
        return ".TP 12" + PlainTextFormatter.getLineSeparator() + key + PlainTextFormatter.getLineSeparator() + this.process(value) + PlainTextFormatter.getLineSeparator();
    }

    public static class KnownSections {
        public static final String NAME = "NAME";
        public static final String SYNOPSIS = "SYNOPSIS";
        public static final String DESCRIPTION = "DESCRIPTION";
        public static final String OPTIONS = "OPTIONS";
        public static final String COMMANDS = "COMMANDS";
        public static final String EXAMPLES = "EXAMPLES";
        public static final String FILES = "FILES";
        public static final String BUGS = "BUGS";
        public static final String AUTHOR = "AUTHOR";
        public static final String SEE_ALSO = "SEE_ALSO";
    }
}

