/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected static final String RCSID = "$Id: StateEdit.java,v 1.6 1997/10/01 20:05:51 sandipc Exp $";
    protected StateEditable object;
    protected Hashtable<Object, Object> preState;
    protected Hashtable<Object, Object> postState;
    protected String undoRedoName;

    public StateEdit(StateEditable obj) {
        this.init(obj, null);
    }

    public StateEdit(StateEditable obj, String name) {
        this.init(obj, name);
    }

    protected void init(StateEditable obj, String name) {
        this.object = obj;
        this.undoRedoName = name;
        this.preState = new Hashtable();
        this.postState = new Hashtable();
        obj.storeState(this.preState);
    }

    public void end() {
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void removeRedundantState() {
        Iterator<Object> i = this.preState.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!this.postState.containsKey(key) || !this.preState.get(key).equals(this.postState.get(key))) continue;
            i.remove();
            this.postState.remove(key);
        }
    }
}

