/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ParagraphView
extends javax.swing.text.ParagraphView {
    private AttributeSet attributes;
    private StyleSheet.BoxPainter painter;
    private Length cssWidth;
    private Length cssHeight;

    public ParagraphView(Element element) {
        super(element);
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.attributes = this.getAttributes();
        if (this.attributes != null) {
            super.setPropertiesFromAttributes();
            Object o = this.attributes.getAttribute(CSS.Attribute.TEXT_ALIGN);
            if (o != null) {
                String align = o.toString();
                if (align.equals("left")) {
                    this.setJustification(0);
                } else if (align.equals("right")) {
                    this.setJustification(2);
                } else if (align.equals("center")) {
                    this.setJustification(1);
                } else if (align.equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.painter = this.getStyleSheet().getBoxPainter(this.attributes);
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            StyleSheet ss = this.getStyleSheet();
            float emBase = ss.getEMBase(this.attributes);
            float exBase = ss.getEXBase(this.attributes);
            this.cssWidth = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
            if (this.cssWidth != null) {
                this.cssWidth.setFontBases(emBase, exBase);
            }
            this.cssHeight = (Length)this.attributes.getAttribute(CSS.Attribute.WIDTH);
            if (this.cssHeight != null) {
                this.cssHeight.setFontBases(emBase, exBase);
            }
        }
    }

    protected StyleSheet getStyleSheet() {
        Document doc = this.getDocument();
        StyleSheet styleSheet = null;
        if (doc instanceof HTMLDocument) {
            styleSheet = ((HTMLDocument)doc).getStyleSheet();
        }
        return styleSheet;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        if (!this.setCSSSpan(r = super.calculateMinorAxisRequirements(axis, r), axis)) {
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
        }
        return r;
    }

    private boolean setCSSSpan(SizeRequirements r, int axis) {
        boolean ret = false;
        if (axis == 0) {
            if (this.cssWidth != null && !this.cssWidth.isPercentage()) {
                r.minimum = (int)this.cssWidth.getValue();
                r.preferred = (int)this.cssWidth.getValue();
                r.maximum = (int)this.cssWidth.getValue();
                ret = true;
            }
        } else if (this.cssHeight != null && !this.cssWidth.isPercentage()) {
            r.minimum = (int)this.cssHeight.getValue();
            r.preferred = (int)this.cssHeight.getValue();
            r.maximum = (int)this.cssHeight.getValue();
            ret = true;
        }
        return ret;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void paint(Graphics g, Shape a) {
        if (a != null) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.painter.paint(g, r.x, r.y, r.width, r.height, this);
        }
        super.paint(g, a);
    }

    public float getPreferredSpan(int axis) {
        float span = 0.0f;
        if (this.isVisible()) {
            span = super.getPreferredSpan(axis);
        }
        return span;
    }

    public float getMinimumSpan(int axis) {
        float span = 0.0f;
        if (this.isVisible()) {
            span = super.getMinimumSpan(axis);
        }
        return span;
    }

    public float getMaximumSpan(int axis) {
        float span = 0.0f;
        if (this.isVisible()) {
            span = super.getMaximumSpan(axis);
        }
        return span;
    }
}

