/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public class FrameSetView
extends BoxView {
    int[][] absolute;
    int[][] relative;
    int[][] percent;
    int[] numViews = new int[2];

    FrameSetView(Element el) {
        super(el, 1);
        this.absolute = new int[2][];
        this.relative = new int[2][];
        this.percent = new int[2][];
    }

    protected void loadChildren(ViewFactory f) {
        this.parseRowsCols();
        View[] rows = new View[this.numViews[1]];
        int r = 0;
        while (r < this.numViews[1]) {
            rows[r] = new FrameSetRow(this.getElement(), r);
            ++r;
        }
        this.replace(0, 0, rows);
    }

    private void parseRowsCols() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        String cols = (String)atts.getAttribute(HTML.Attribute.COLS);
        if (cols == null) {
            cols = "100%";
        }
        this.parseLayout(cols, 0);
        String rows = (String)atts.getAttribute(HTML.Attribute.ROWS);
        if (rows == null) {
            rows = "100%";
        }
        this.parseLayout(rows, 1);
    }

    private void parseLayout(String att, int axis) {
        StringTokenizer tokens = new StringTokenizer(att, ",");
        this.numViews[axis] = tokens.countTokens();
        this.absolute[axis] = new int[this.numViews[axis]];
        this.relative[axis] = new int[this.numViews[axis]];
        this.percent[axis] = new int[this.numViews[axis]];
        int index = 0;
        while (tokens.hasMoreTokens()) {
            String number;
            String token = tokens.nextToken();
            int p = token.indexOf(37);
            int s = token.indexOf(42);
            if (p != -1) {
                number = token.substring(0, p);
                try {
                    this.percent[axis][index] = Integer.parseInt(number);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (s != -1) {
                number = token.substring(0, s);
                try {
                    this.relative[axis][index] = Integer.parseInt(number);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                try {
                    this.absolute[axis][index] = Integer.parseInt(token);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++index;
        }
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int numRows = this.numViews[1];
        int[] abs = this.absolute[1];
        int[] rel = this.relative[1];
        int[] perc = this.percent[1];
        this.layoutViews(targetSpan, axis, offsets, spans, numRows, abs, rel, perc);
    }

    void layoutViews(int targetSpan, int axis, int[] offsets, int[] spans, int numViews, int[] abs, int[] rel, int[] perc) {
        int total = 0;
        int relTotal = 0;
        int i = 0;
        while (i < numViews) {
            if (abs[i] > 0) {
                spans[i] = abs[i];
                total += spans[i];
            } else if (perc[i] > 0) {
                spans[i] = targetSpan * perc[i] / 100;
                total += spans[i];
            } else if (rel[i] > 0) {
                relTotal += rel[i];
            }
            ++i;
        }
        int offs = 0;
        int i2 = 0;
        while (i2 < numViews) {
            if (relTotal > 0 && rel[i2] > 0) {
                spans[i2] = targetSpan * (rel[i2] / relTotal);
            }
            offsets[i2] = offs;
            offs += spans[i2];
            ++i2;
        }
    }

    private class FrameSetRow
    extends BoxView {
        private int row;

        FrameSetRow(Element el, int r) {
            super(el, 0);
            this.row = r;
        }

        protected void loadChildren(ViewFactory f) {
            Element el = this.getElement();
            View[] columns = new View[FrameSetView.this.numViews[0]];
            int offset = this.row * FrameSetView.this.numViews[0];
            int c = 0;
            while (c < FrameSetView.this.numViews[0]) {
                Element child = el.getElement(offset + c);
                columns[c] = f.create(child);
                ++c;
            }
            this.replace(0, 0, columns);
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            int numRows = FrameSetView.this.numViews[0];
            int[] abs = FrameSetView.this.absolute[0];
            int[] rel = FrameSetView.this.relative[0];
            int[] perc = FrameSetView.this.percent[0];
            FrameSetView.this.layoutViews(targetSpan, axis, offsets, spans, numRows, abs, rel, perc);
        }
    }
}

