/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    ArrayList marks;
    private int garbageMarks;
    private Mark searchMark = new Mark(0);
    ReferenceQueue queueOfDeath;

    public GapContent() {
        this(10);
    }

    public GapContent(int size) {
        size = Math.max(size, 2);
        this.buffer = (char[])this.allocateArray(size);
        this.gapStart = 1;
        this.gapEnd = size;
        this.buffer[0] = 10;
        this.marks = new ArrayList();
        this.queueOfDeath = new ReferenceQueue();
    }

    protected Object allocateArray(int size) {
        return new char[size];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        int length = this.length();
        int strLen = str.length();
        if (where < 0) {
            throw new BadLocationException("The where argument cannot be smaller than the zero", where);
        }
        if (where > length) {
            throw new BadLocationException("The where argument cannot be greater than the content length", where);
        }
        InsertUndo undo = new InsertUndo(where, strLen);
        this.replace(where, 0, str.toCharArray(), strLen);
        return undo;
    }

    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        int length = this.length();
        if (where + nitems >= length) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", where + nitems);
        }
        String removedText = this.getString(where, nitems);
        UndoRemove undoRemove = new UndoRemove(where, removedText);
        this.replace(where, nitems, null, 0);
        return undoRemove;
    }

    public String getString(int where, int len) throws BadLocationException {
        Segment seg = new Segment();
        try {
            this.getChars(where, len, seg);
            return new String(seg.array, seg.offset, seg.count);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            int invalid = 0;
            invalid = seg.offset < 0 || seg.offset >= seg.array.length ? seg.offset : seg.offset + seg.count;
            throw new BadLocationException("Illegal location: array.length = " + seg.array.length + ", offset = " + seg.offset + ", count = " + seg.count, invalid);
        }
    }

    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        int length = this.length();
        if (where < 0) {
            throw new BadLocationException("the where argument may not be below zero", where);
        }
        if (where >= length) {
            throw new BadLocationException("the where argument cannot be greater than the content length", where);
        }
        if (where + len > length) {
            throw new BadLocationException("len plus where cannot be greater than the content length", len + where);
        }
        if (len < 0) {
            throw new BadLocationException("negative length not allowed: ", len);
        }
        if (where + len <= this.gapStart) {
            txt.array = this.buffer;
            txt.offset = where;
            txt.count = len;
        } else if (where > this.gapStart) {
            txt.array = this.buffer;
            txt.offset = this.gapEnd + where - this.gapStart;
            txt.count = len;
        } else {
            int beforeGap = this.gapStart - where;
            if (txt.isPartialReturn()) {
                txt.array = this.buffer;
                txt.offset = where;
                txt.count = beforeGap;
            } else {
                txt.array = new char[len];
                txt.offset = 0;
                System.arraycopy(this.buffer, where, txt.array, 0, beforeGap);
                System.arraycopy(this.buffer, this.gapEnd, txt.array, beforeGap, len - beforeGap);
                txt.count = len;
            }
        }
    }

    public Position createPosition(int offset) throws BadLocationException {
        GapContentPosition pos;
        block7: {
            Mark m;
            int insertIndex;
            int index;
            block6: {
                while (this.queueOfDeath.poll() != null) {
                    ++this.garbageMarks;
                }
                if (this.garbageMarks > Math.max(5, this.marks.size() / 10)) {
                    this.garbageCollect();
                }
                index = offset;
                if (offset >= this.gapStart) {
                    index += this.gapEnd - this.gapStart;
                }
                this.searchMark.mark = index;
                insertIndex = this.search(this.searchMark);
                if (insertIndex >= this.marks.size()) break block6;
                m = (Mark)this.marks.get(insertIndex);
                if (m.mark == index && (pos = m.getPosition()) != null) break block7;
            }
            pos = new GapContentPosition();
            pos.mark = m = new Mark(index, pos, this.queueOfDeath);
            this.marks.add(insertIndex, m);
        }
        return pos;
    }

    protected void shiftEnd(int newSize) {
        assert (newSize > this.gapEnd - this.gapStart) : "The new gap size must be greater than the old gap size";
        int oldEnd = this.getGapEnd();
        int oldSize = this.getArrayLength();
        int upper = oldSize - oldEnd;
        int size = (newSize + 1) * 2;
        int newEnd = size - upper;
        char[] newBuf = (char[])this.allocateArray(size);
        System.arraycopy(this.buffer, 0, newBuf, 0, Math.min(size, oldSize));
        this.buffer = newBuf;
        this.gapEnd = newEnd;
        if (upper != 0) {
            System.arraycopy(this.buffer, oldEnd, this.buffer, newEnd, upper);
        }
        int delta = this.gapEnd - oldEnd;
        int adjIndex = this.searchFirst(oldEnd);
        int count = this.marks.size();
        int i = adjIndex;
        while (i < count) {
            Mark m = (Mark)this.marks.get(i);
            m.mark += delta;
            ++i;
        }
    }

    protected void shiftGap(int newGapStart) {
        int oldStart = this.gapStart;
        int delta = newGapStart - oldStart;
        int oldEnd = this.gapEnd;
        int newGapEnd = oldEnd + delta;
        int size = oldEnd - oldStart;
        this.gapStart = newGapStart;
        this.gapEnd = newGapEnd;
        if (delta > 0) {
            System.arraycopy(this.buffer, oldEnd, this.buffer, oldStart, delta);
        } else {
            System.arraycopy(this.buffer, newGapStart, this.buffer, newGapEnd, -delta);
        }
        if (delta > 0) {
            int adjIndex = this.searchFirst(oldStart);
            int count = this.marks.size();
            int i = adjIndex;
            while (i < count) {
                Mark m = (Mark)this.marks.get(i);
                if (m.mark < newGapEnd) {
                    m.mark -= size;
                    ++i;
                    continue;
                }
                break;
            }
        } else if (delta < 0) {
            int adjIndex = this.searchFirst(newGapStart);
            int count = this.marks.size();
            int i = adjIndex;
            while (i < count) {
                Mark m = (Mark)this.marks.get(i);
                if (m.mark < oldEnd) {
                    m.mark += size;
                    ++i;
                    continue;
                }
                break;
            }
        }
        this.resetMarksAtZero();
    }

    protected void shiftGapStartDown(int newGapStart) {
        if (newGapStart == this.gapStart) {
            return;
        }
        assert (newGapStart < this.gapStart) : "The new gap start must be less than the old gap start.";
        int adjIndex = this.searchFirst(newGapStart);
        int count = this.marks.size();
        int i = adjIndex;
        while (i < count) {
            Mark m = (Mark)this.marks.get(i);
            if (m.mark > this.gapStart) break;
            m.mark = this.gapEnd;
            ++i;
        }
        this.gapStart = newGapStart;
        this.resetMarksAtZero();
    }

    protected void shiftGapEndUp(int newGapEnd) {
        if (newGapEnd == this.gapEnd) {
            return;
        }
        assert (newGapEnd > this.gapEnd) : "The new gap end must be greater than the old gap end.";
        int adjIndex = this.searchFirst(this.gapEnd);
        int count = this.marks.size();
        int i = adjIndex;
        while (i < count) {
            Mark m = (Mark)this.marks.get(i);
            if (m.mark >= newGapEnd) break;
            m.mark = newGapEnd;
            ++i;
        }
        this.gapEnd = newGapEnd;
        this.resetMarksAtZero();
    }

    protected final Object getArray() {
        return this.buffer;
    }

    protected void replace(int position, int rmSize, Object addItems, int addSize) {
        if (addSize == 0) {
            this.removeImpl(position, rmSize);
            return;
        }
        if (rmSize > addSize) {
            this.removeImpl(position + addSize, rmSize - addSize);
        } else {
            int endSize = addSize - rmSize;
            int end = this.addImpl(position + rmSize, endSize);
            System.arraycopy(addItems, rmSize, this.buffer, end, endSize);
            addSize = rmSize;
        }
        System.arraycopy(addItems, 0, this.buffer, position, addSize);
    }

    private void removeImpl(int pos, int num) {
        if (num > 0) {
            int end = pos + num;
            int newGapSize = this.gapEnd - this.gapStart + num;
            if (end <= this.gapStart) {
                if (this.gapStart != end) {
                    this.shiftGap(end);
                }
                this.shiftGapStartDown(this.gapStart - num);
            } else if (pos >= this.gapStart) {
                if (this.gapStart != pos) {
                    this.shiftGap(pos);
                }
                this.shiftGapEndUp(this.gapStart + newGapSize);
            } else {
                this.shiftGapStartDown(pos);
                this.shiftGapEndUp(this.gapStart + newGapSize);
            }
        }
    }

    private int addImpl(int pos, int num) {
        int size = this.gapEnd - this.gapStart;
        if (num == 0) {
            if (pos > this.gapStart) {
                pos += size;
            }
            return pos;
        }
        this.shiftGap(pos);
        if (num >= size) {
            this.shiftEnd(this.getArrayLength() - size + num);
            size = this.gapEnd - this.gapStart;
        }
        this.gapStart += num;
        return pos;
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector v, int offset, int length) {
        int endIndex;
        int startIndex;
        int end = offset + length;
        if (offset < this.gapStart) {
            startIndex = offset == 0 ? 0 : this.searchFirst(offset);
            endIndex = end >= this.gapStart ? this.searchFirst(end + (this.gapEnd - this.gapStart) + 1) : this.searchFirst(end + 1);
        } else {
            startIndex = this.searchFirst(offset + (this.gapEnd - this.gapStart));
            endIndex = this.searchFirst(end + (this.gapEnd - this.gapStart) + 1);
        }
        if (v == null) {
            v = new Vector<UndoPosRef>();
        }
        int i = startIndex;
        while (i < endIndex) {
            v.add(new UndoPosRef((Mark)this.marks.get(i)));
            ++i;
        }
        return v;
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        int i = 0;
        while (i < this.marks.size()) {
            Mark m = (Mark)this.marks.get(i);
            if (m.mark <= this.gapEnd) {
                m.mark = 0;
            }
            ++i;
        }
    }

    protected void updateUndoPositions(Vector positions, int offset, int length) {
        for (UndoPosRef undoPosRef : positions) {
            undoPosRef.reset();
        }
        Collections.sort(this.marks);
    }

    private void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        int i = 0;
        while (i < this.buffer.length) {
            if (i == this.gapStart) {
                System.err.print('<');
            }
            if (i == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[i])) {
                System.err.print(this.buffer[i]);
            } else {
                System.err.print('.');
            }
            ++i;
        }
        System.err.println();
    }

    private void dumpMarks() {
        System.out.print("positionMarks: ");
        int i = 0;
        while (i < this.marks.size()) {
            System.out.print(String.valueOf(((Mark)this.marks.get((int)i)).mark) + ", ");
            ++i;
        }
        System.out.println();
    }

    /*
     * Unable to fully structure code
     */
    int search(Mark o) {
        block4: {
            foundInd = 0;
            found = false;
            low = 0;
            up = this.marks.size() - 1;
            mid = 0;
            if (up <= -1) break block4;
            cmp = 0;
            last = (Mark)this.marks.get(up);
            cmp = this.compare(o, last);
            if (cmp <= 0) ** GOTO lbl25
            foundInd = up + 1;
            found = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                mid = low + (up - low) / 2;
                m = (Mark)this.marks.get(mid);
                cmp = this.compare(o, m);
                if (cmp == 0) {
                    foundInd = mid;
                    found = true;
                    continue;
                }
                if (cmp < 0) {
                    up = mid - 1;
                    continue;
                }
                low = mid + 1;
lbl25:
                // 4 sources

                ** while (low <= up && !found)
            }
lbl26:
            // 1 sources

            if (!found) {
                foundInd = cmp < 0 ? mid : mid + 1;
            }
        }
        return foundInd;
    }

    private int searchFirst(int index) {
        this.searchMark.mark = Math.max(index, 1);
        int i = this.search(this.searchMark);
        int j = i - 1;
        while (j >= 0) {
            Mark m = (Mark)this.marks.get(j);
            if (m.mark != index) break;
            --i;
            --j;
        }
        return i;
    }

    private int compare(Mark m1, Mark m2) {
        return m1.mark - m2.mark;
    }

    private void garbageCollect() {
        int count = this.marks.size();
        ArrayList<Mark> clean = new ArrayList<Mark>();
        int i = 0;
        while (i < count) {
            Mark m = (Mark)this.marks.get(i);
            if (m.get() != null) {
                clean.add(m);
            }
            ++i;
        }
        this.marks = clean;
        this.garbageMarks = 0;
    }

    class GapContentPosition
    implements Position {
        Mark mark;

        GapContentPosition() {
        }

        public int getOffset() {
            return this.mark.getOffset();
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        public int where;
        public int length;
        String text;
        private Vector positions;

        public InsertUndo(int start, int len) {
            this.where = start;
            this.length = len;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.positions = GapContent.this.getPositionsInRange(null, this.where, this.length);
                this.text = GapContent.this.getString(this.where, this.length);
                GapContent.this.remove(this.where, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.insertString(this.where, this.text);
                if (this.positions != null) {
                    GapContent.this.updateUndoPositions(this.positions, this.where, this.length);
                    this.positions = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class Mark
    extends WeakReference {
        int mark;

        Mark(int offset) {
            super(null);
            this.mark = offset;
        }

        Mark(int offset, GapContentPosition pos, ReferenceQueue queue) {
            super(pos, queue);
            this.mark = offset;
        }

        int getOffset() {
            int res = this.mark;
            if (this.mark >= GapContent.this.gapStart) {
                res -= GapContent.this.gapEnd - GapContent.this.gapStart;
            }
            return Math.max(0, res);
        }

        GapContentPosition getPosition() {
            return (GapContentPosition)this.get();
        }
    }

    private class UndoPosRef {
        private Mark mark;
        private int undoOffset;

        UndoPosRef(Mark m) {
            this.mark = m;
            this.undoOffset = this.mark.getOffset();
        }

        void reset() {
            this.mark.mark = this.undoOffset <= GapContent.this.gapStart ? this.undoOffset : GapContent.this.gapEnd - GapContent.this.gapStart + this.undoOffset;
        }
    }

    private class UndoRemove
    extends AbstractUndoableEdit {
        public int where;
        String text;
        private Vector positions;

        public UndoRemove(int start, String removedText) {
            this.where = start;
            this.text = removedText;
            this.positions = GapContent.this.getPositionsInRange(null, start, removedText.length());
        }

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.where, this.text);
                if (this.positions != null) {
                    GapContent.this.updateUndoPositions(this.positions, this.where, this.text.length());
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                this.text = GapContent.this.getString(this.where, this.text.length());
                this.positions = GapContent.this.getPositionsInRange(null, this.where, this.text.length());
                GapContent.this.remove(this.where, this.text.length());
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }
}

