/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    BoundedRangeModel horizontalVisibility;
    float cachedSpan = -1.0f;

    public FieldView(Element elem) {
        super(elem);
    }

    private void checkContainer() {
        Container c = this.getContainer();
        if (c instanceof JTextField) {
            this.horizontalVisibility = ((JTextField)c).getHorizontalVisibility();
            this.horizontalVisibility.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    FieldView.this.getContainer().repaint();
                }
            });
            this.calculateHorizontalSpan();
            this.updateVisibility();
        }
    }

    private void updateVisibility() {
        JTextField tf = (JTextField)this.getContainer();
        Insets insets = tf.getInsets();
        int width = tf.getWidth() - insets.left - insets.right;
        this.horizontalVisibility.setMaximum(Math.max((int)(this.cachedSpan != -1.0f ? this.cachedSpan : this.calculateHorizontalSpan()), width));
        this.horizontalVisibility.setExtent(width - 1);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    protected Shape adjustAllocation(Shape shape) {
        int x;
        if (shape == null) {
            return null;
        }
        Rectangle rectIn = shape.getBounds();
        int height = (int)this.getPreferredSpan(1);
        int y = rectIn.y + (rectIn.height - height) / 2;
        JTextField textField = (JTextField)this.getContainer();
        int width = (int)(this.cachedSpan != -1.0f ? this.cachedSpan : this.calculateHorizontalSpan());
        if (this.horizontalVisibility != null && this.horizontalVisibility.getExtent() < width) {
            x = rectIn.x - this.horizontalVisibility.getValue();
        } else {
            switch (textField.getHorizontalAlignment()) {
                case 0: {
                    x = rectIn.x + (rectIn.width - width) / 2;
                    break;
                }
                case 4: {
                    x = rectIn.x + (rectIn.width - width - 1);
                    break;
                }
                case 11: {
                    if (textField.getComponentOrientation().isLeftToRight()) {
                        x = rectIn.x + (rectIn.width - width - 1);
                        break;
                    }
                    x = rectIn.x;
                    break;
                }
                case 10: {
                    if (textField.getComponentOrientation().isLeftToRight()) {
                        x = rectIn.x;
                        break;
                    }
                    x = rectIn.x + (rectIn.width - width - 1);
                    break;
                }
                default: {
                    x = rectIn.x;
                }
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public float getPreferredSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        if (axis == 1) {
            return super.getPreferredSpan(axis);
        }
        if (this.cachedSpan != -1.0f) {
            return this.cachedSpan;
        }
        return this.calculateHorizontalSpan();
    }

    private float calculateHorizontalSpan() {
        Segment s = this.getLineBuffer();
        Element elem = this.getElement();
        try {
            elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - 1, s);
            this.cachedSpan = Utilities.getTabbedTextWidth(s, this.getFontMetrics(), 0, this, s.offset);
            return this.cachedSpan;
        }
        catch (BadLocationException e) {
            AssertionError ae = new AssertionError();
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public int getResizeWeight(int axis) {
        return axis == 0 ? 1 : 0;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        Shape newAlloc = this.adjustAllocation(a);
        return super.modelToView(pos, newAlloc, bias);
    }

    public void paint(Graphics g, Shape s) {
        if (this.horizontalVisibility == null) {
            this.checkContainer();
        }
        Shape newAlloc = this.adjustAllocation(s);
        Shape clip = g.getClip();
        if (clip != null) {
            Rectangle r = s.getBounds();
            Rectangle cb = clip.getBounds();
            SwingUtilities.computeIntersection(r.x, r.y, r.width, r.height, cb);
            g.setClip(cb);
        } else {
            g.setClip(s);
        }
        super.paint(g, newAlloc);
        g.setClip(clip);
    }

    public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape newAlloc = this.adjustAllocation(shape);
        super.insertUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape newAlloc = this.adjustAllocation(shape);
        super.removeUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        this.cachedSpan = -1.0f;
        if (this.horizontalVisibility != null) {
            this.updateVisibility();
        }
        Shape newAlloc = this.adjustAllocation(shape);
        super.changedUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        return super.viewToModel(fx, fy, this.adjustAllocation(a), bias);
    }
}

