/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.classpath.SystemProperties;
import gnu.javax.management.ListenerData;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerDelegateMBean;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class MBeanServerDelegate
implements MBeanServerDelegateMBean,
NotificationEmitter {
    private String id;
    private final List<ListenerData> listeners = new ArrayList<ListenerData>();
    private long seqNo;

    public MBeanServerDelegate() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            hostName = "Unknown host";
        }
        this.id = String.valueOf(hostName) + "_" + new Date().getTime();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("A null listener was supplied.");
        }
        this.listeners.add(new ListenerData(listener, filter, passback));
    }

    public String getImplementationName() {
        return "GNU JMX";
    }

    public String getImplementationVendor() {
        return "The GNU Classpath Project";
    }

    public String getImplementationVersion() {
        return SystemProperties.getProperty("gnu.classpath.version");
    }

    public String getMBeanServerId() {
        return this.id;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"JMX.mbean.registered", "JMX.mbean.unregistered"}, MBeanServerNotification.class.getName(), "Server registration notifications")};
    }

    public String getSpecificationName() {
        return "JMX";
    }

    public String getSpecificationVendor() {
        return "Sun Microsystems";
    }

    public String getSpecificationVersion() {
        return "1.2";
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Iterator<ListenerData> it = this.listeners.iterator();
        boolean foundOne = false;
        while (it.hasNext()) {
            if (it.next().getListener() != listener) continue;
            it.remove();
            foundOne = true;
        }
        if (!foundOne) {
            throw new ListenerNotFoundException("The specified listener, " + listener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(listener, filter, passback))) {
            throw new ListenerNotFoundException("The specified listener, " + listener + " with filter " + filter + "and passback " + passback + ", is not registered with this bean.");
        }
    }

    public void sendNotification(Notification notification) {
        if (notification.getSequenceNumber() <= 0L) {
            notification.setSequenceNumber(++this.seqNo);
        }
        for (ListenerData ldata : this.listeners) {
            NotificationFilter filter = ldata.getFilter();
            if (filter != null && !filter.isNotificationEnabled(notification)) continue;
            ldata.getListener().handleNotification(notification, ldata.getPassback());
        }
    }
}

