/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import gnu.classpath.ServiceFactory;
import gnu.classpath.SystemProperties;
import gnu.java.rmi.server.RMIClassLoaderImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClassLoaderSpi;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIClassLoader {
    private RMIClassLoader() {
    }

    public static Class<?> loadClass(String name) throws MalformedURLException, ClassNotFoundException {
        return RMIClassLoader.loadClass("", name);
    }

    public static Class<?> loadClass(String codebase, String name) throws MalformedURLException, ClassNotFoundException {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.loadClass(codebase, name, null);
    }

    public static Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.loadClass(codebase, name, defaultLoader);
    }

    public static Class<?> loadProxyClass(String codeBase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.loadProxyClass(codeBase, interfaces, defaultLoader);
    }

    public static Class<?> loadClass(URL codeBase, String name) throws MalformedURLException, ClassNotFoundException {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.loadClass(codeBase.toString(), name, null);
    }

    public static ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.getClassLoader(codebase);
    }

    public static String getClassAnnotation(Class<?> cl) {
        RMIClassLoaderSpi spi = RMIClassLoader.getProviderInstance();
        if (spi == null) {
            spi = RMIClassLoader.getDefaultProviderInstance();
        }
        return spi.getClassAnnotation(cl);
    }

    public static Object getSecurityContext(ClassLoader loader) {
        throw new Error("Not implemented");
    }

    public static RMIClassLoaderSpi getDefaultProviderInstance() {
        return RMIClassLoaderImpl.getInstance();
    }

    private static RMIClassLoaderSpi getProviderInstance() {
        String prop = SystemProperties.getProperty("java.rmi.server.RMIClassLoaderSpi");
        if ("default".equals(prop)) {
            return null;
        }
        Iterator<RMIClassLoaderSpi> it = ServiceFactory.lookupProviders(RMIClassLoaderSpi.class, null);
        if (it == null || !it.hasNext()) {
            return null;
        }
        return it.next();
    }
}

