/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.parser.support.low;

import gnu.javax.swing.text.html.parser.support.low.Buffer;
import gnu.javax.swing.text.html.parser.support.low.Constants;
import gnu.javax.swing.text.html.parser.support.low.Location;
import gnu.javax.swing.text.html.parser.support.low.ParseException;
import gnu.javax.swing.text.html.parser.support.low.Queue;
import gnu.javax.swing.text.html.parser.support.low.Token;
import java.io.IOException;
import java.io.Reader;

public class ReaderTokenizer
extends Constants {
    protected boolean advanced;
    protected boolean backupMode;
    Buffer buffer = new Buffer();
    Queue backup = new Queue();
    Queue queue = new Queue();
    Reader reader;
    char[] charTokens;
    String[] stringTokens;
    int readerPosition = -1;

    public String getEndOfLineSequence() {
        return this.buffer.getEndOfLineSequence();
    }

    public Token getNextToken() {
        Token rt;
        this.advanced = true;
        try {
            if (this.queue.isEmpty()) {
                this.read(1);
            }
            rt = !this.queue.isEmpty() ? this.queue.next() : new Token(3, new Location(this.readerPosition));
        }
        catch (IOException ex) {
            throw new ParseException("IO Exception", ex);
        }
        if (this.backupMode) {
            this.backup.add(rt);
        }
        return rt;
    }

    public Token getTokenAhead(int ahead) {
        try {
            this.read(ahead - this.queue.size() + 1);
            return this.queue.size() >= ahead ? this.queue.get(ahead) : this.eofToken();
        }
        catch (IOException ex) {
            throw new ParseException("IO Exception", ex);
        }
    }

    public Token getTokenAhead() {
        try {
            if (this.queue.isEmpty()) {
                this.read(1);
            }
            if (!this.queue.isEmpty()) {
                return this.queue.get(0);
            }
            return this.eofToken();
        }
        catch (IOException ex) {
            throw new ParseException("IO Exception", ex);
        }
    }

    public void error(String msg, Token at) {
        System.out.println(msg);
    }

    public void mark(boolean mode) {
        this.backup.clear();
        this.backupMode = mode;
    }

    public void reset(Reader a_reader) {
        this.reader = a_reader;
        this.readerPosition = -1;
        this.buffer.reset();
        this.queue.clear();
    }

    public void reset() {
        if (!this.backupMode) {
            throw new AssertionError((Object)"Call mark(true) before using reset()!");
        }
        this.backupMode = false;
        while (!this.queue.isEmpty()) {
            this.backup.add(this.queue.next());
        }
        Queue t = this.queue;
        this.queue = this.backup;
        this.backup = t;
        this.backup.clear();
    }

    void read(int numberOfTokens) throws IOException {
        if (numberOfTokens <= 0) {
            return;
        }
        int i = 0;
        while (i < numberOfTokens) {
            this.readToken();
            ++i;
        }
    }

    void readToken() throws IOException {
        Token t;
        while ((t = this.tokenMatches()) == null) {
            int ch = this.reader.read();
            ++this.readerPosition;
            if (ch == 3) {
                ch = 32;
            }
            if (ch < 0) {
                if (this.buffer.length() == 0) {
                    this.queue.add(this.eofToken());
                    return;
                }
                if (this.buffer.charAt(this.buffer.length() - 1) != '\u0003') {
                    this.buffer.append('\u0003', this.readerPosition++);
                    continue;
                }
                this.buffer.setLength(this.buffer.length() - 1);
                if (this.buffer.length() > 0) {
                    t = new Token(1999, this.buffer.toString(), this.buffer.getLocation(0, this.buffer.length()));
                    this.queue.add(t);
                    this.buffer.setLength(0);
                }
                return;
            }
            this.buffer.append((char)ch, this.readerPosition);
        }
    }

    Token tokenMatches() {
        Token rt = this.endMatches(this.buffer);
        if (rt != null) {
            if (rt.kind == 1004) {
                if (this.buffer.charAt(this.buffer.length() - 1) == ';') {
                    this.buffer.setLength(this.buffer.length() - rt.getImage().length() - 1);
                } else {
                    this.error("Missing closing semicolon for entity '" + rt.getImage() + "'", rt);
                    this.consumeBuffer(rt);
                }
            } else {
                this.consumeBuffer(rt);
            }
        }
        if (rt != null) {
            if (this.buffer.length() > 1) {
                String rest = this.buffer.toString();
                rest = rest.substring(0, rest.length() - 1);
                Token other = new Token(1999, rest, this.buffer.getLocation(0, this.buffer.length));
                this.queue.add(other);
                this.consumeBuffer(other);
            }
            this.queue.add(rt);
        }
        return rt;
    }

    private void consumeBuffer(Token rt) {
        this.buffer.delete(this.buffer.length() - rt.getImage().length() - 1, this.buffer.length() - 1);
    }

    private Token eofToken() {
        return new Token(3, "#", new Location(this.readerPosition));
    }
}

