/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key;

import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import gnu.java.security.util.FormatUtil;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyPairCodecFactory {
    private static Set names;

    private KeyPairCodecFactory() {
    }

    public static IKeyPairCodec getInstance(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        if (name.startsWith("/")) {
            return null;
        }
        if (name.endsWith("/")) {
            return KeyPairCodecFactory.getInstance(name.substring(0, name.length() - 1), 1);
        }
        int i = name.indexOf("/");
        if (i == -1) {
            return KeyPairCodecFactory.getInstance(name, 1);
        }
        String kpgName = name.substring(0, i);
        String formatName = name.substring(i + 1);
        return KeyPairCodecFactory.getInstance(kpgName, formatName);
    }

    public static IKeyPairCodec getInstance(String name, String format) {
        int formatID = FormatUtil.getFormatID(format);
        if (formatID == 0) {
            return null;
        }
        return KeyPairCodecFactory.getInstance(name, formatID);
    }

    public static IKeyPairCodec getInstance(String name, int formatID) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        switch (formatID) {
            case 1: {
                return KeyPairCodecFactory.getRawCodec(name);
            }
            case 2: {
                return KeyPairCodecFactory.getX509Codec(name);
            }
            case 3: {
                return KeyPairCodecFactory.getPKCS8Codec(name);
            }
        }
        return null;
    }

    public static IKeyPairCodec getInstance(Key key) {
        if (key == null) {
            return null;
        }
        String format = key.getFormat();
        int formatID = FormatUtil.getFormatID(format);
        if (formatID == 0) {
            return null;
        }
        switch (formatID) {
            case 1: {
                return KeyPairCodecFactory.getRawCodec(key);
            }
            case 2: {
                return KeyPairCodecFactory.getX509Codec(key);
            }
            case 3: {
                return KeyPairCodecFactory.getPKCS8Codec(key);
            }
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet<String> hs = new HashSet<String>();
            hs.add("dss/RAW");
            hs.add("dss/X.509");
            hs.add("dss/PKCS#8");
            hs.add("rsa/RAW");
            hs.add("rsa/X.509");
            hs.add("rsa/PKCS#8");
            hs.add("dh/RAW");
            hs.add("srp/RAW");
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }

    private static IKeyPairCodec makeInstance(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            Constructor<?> ctor = c.getConstructor(new Class[0]);
            return (IKeyPairCodec)ctor.newInstance(new Object[0]);
        }
        catch (Exception x) {
            IllegalArgumentException iae = new IllegalArgumentException("strong crypto key codec not available: " + clazz);
            iae.initCause(x);
            throw iae;
        }
    }

    private static boolean matches(Object o, String clazz) {
        try {
            Class<? extends Object> c = Class.forName(clazz);
            return c.isAssignableFrom(o.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static IKeyPairCodec getRawCodec(String name) {
        IKeyPairCodec result = null;
        if (name.equalsIgnoreCase("dsa") || name.equals("dss")) {
            result = new DSSKeyPairRawCodec();
        } else if (name.equalsIgnoreCase("rsa")) {
            result = new RSAKeyPairRawCodec();
        } else if (name.equalsIgnoreCase("dh")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairRawCodec");
        } else if (name.equalsIgnoreCase("srp")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec");
        }
        return result;
    }

    private static IKeyPairCodec getX509Codec(String name) {
        IKeyPairCodec result = null;
        if (name.equalsIgnoreCase("dsa") || name.equals("dss")) {
            result = new DSSKeyPairX509Codec();
        } else if (name.equalsIgnoreCase("rsa")) {
            result = new RSAKeyPairX509Codec();
        } else if (name.equalsIgnoreCase("dh")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairX509Codec");
        }
        return result;
    }

    private static IKeyPairCodec getPKCS8Codec(String name) {
        IKeyPairCodec result = null;
        if (name.equalsIgnoreCase("dsa") || name.equals("dss")) {
            result = new DSSKeyPairPKCS8Codec();
        } else if (name.equalsIgnoreCase("rsa")) {
            result = new RSAKeyPairPKCS8Codec();
        } else if (name.equalsIgnoreCase("dh")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec");
        }
        return result;
    }

    private static IKeyPairCodec getRawCodec(Key key) {
        IKeyPairCodec result = null;
        if (key instanceof DSSPublicKey || key instanceof DSSPrivateKey) {
            result = new DSSKeyPairRawCodec();
        } else if (key instanceof GnuRSAPublicKey || key instanceof GnuRSAPrivateKey) {
            result = new RSAKeyPairRawCodec();
        } else if (KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.dh.GnuDHPublicKey") || KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.dh.GnuDHPrivateKey")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairRawCodec");
        } else if (KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.srp6.SRPPublicKey") || KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.srp6.SRPPrivateKey")) {
            result = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec");
        }
        return result;
    }

    private static IKeyPairCodec getX509Codec(Key key) {
        IKeyPairCodec result = null;
        if (key instanceof DSSPublicKey) {
            result = new DSSKeyPairX509Codec();
        } else if (key instanceof GnuRSAPublicKey) {
            result = new RSAKeyPairX509Codec();
        }
        return result;
    }

    private static IKeyPairCodec getPKCS8Codec(Key key) {
        IKeyPairCodec result = null;
        if (key instanceof DSSPrivateKey) {
            result = new DSSKeyPairPKCS8Codec();
        } else if (key instanceof GnuRSAPrivateKey) {
            result = new RSAKeyPairPKCS8Codec();
        }
        return result;
    }
}

