/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingMenuBarPeer;
import gnu.java.awt.peer.swing.SwingWindowPeer;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.peer.FramePeer;

public abstract class SwingFramePeer
extends SwingWindowPeer
implements FramePeer {
    SwingMenuBarPeer menuBar = null;

    public SwingFramePeer(Frame frame) {
        super(frame);
    }

    public void setMenuBar(MenuBar mb) {
        this.menuBar = (SwingMenuBarPeer)mb.getPeer();
        this.menuBar.setFramePeer(this);
        this.menuBar.setWidth(this.awtComponent.getWidth());
    }

    protected void peerPaintComponent(Graphics g) {
        super.peerPaintComponent(g);
        if (this.menuBar != null) {
            this.menuBar.peerPaint(g);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        if (this.menuBar != null) {
            this.menuBar.setWidth(w);
        }
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.menuBar != null) {
            insets.top += this.menuBar.getHeight();
        }
        return insets;
    }

    public Point getMenuLocationOnScreen() {
        Insets i = super.getInsets();
        return new Point(i.top, i.left);
    }

    protected void handleMouseEvent(MouseEvent ev) {
        Point p = ev.getPoint();
        Insets i = super.getInsets();
        if (this.menuBar != null) {
            int menuHeight = this.menuBar.getHeight();
            if (p.y >= i.top && p.y <= i.top + menuHeight) {
                this.menuBar.handleMouseEvent(ev);
            } else {
                ev.translatePoint(0, -menuHeight);
                super.handleMouseMotionEvent(ev);
            }
        }
        super.handleMouseEvent(ev);
    }

    protected void handleMouseMotionEvent(MouseEvent ev) {
        Point p = ev.getPoint();
        Insets i = super.getInsets();
        if (this.menuBar != null) {
            int menuHeight = this.menuBar.getHeight();
            if (p.y >= i.top && p.y <= i.top + menuHeight) {
                this.menuBar.handleMouseMotionEvent(ev);
            } else {
                ev.translatePoint(0, -menuHeight);
                super.handleMouseMotionEvent(ev);
            }
        }
        super.handleMouseMotionEvent(ev);
    }
}

