/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GdkGraphicsConfiguration;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;

class GdkScreenGraphicsDevice
extends GraphicsDevice {
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private Window fullscreenWindow;
    private boolean oldWindowDecorationState;
    private Rectangle oldWindowBounds;
    private Rectangle bounds;
    private GdkGraphicsConfiguration[] configurations;
    GdkGraphicsEnvironment env;
    String idString;
    X11DisplayMode[] displayModes;
    DisplayMode fixedDisplayMode;
    private Pointer screen;

    static {
        System.loadLibrary("gtkpeer");
        GtkToolkit.initializeGlobalIDs();
        GdkScreenGraphicsDevice.initIDs();
    }

    static native void initIDs();

    GdkScreenGraphicsDevice(GdkGraphicsEnvironment e) {
        this.env = e;
        this.configurations = new GdkGraphicsConfiguration[1];
        this.configurations[0] = new GdkGraphicsConfiguration(this);
    }

    void init() {
        this.fixedDisplayMode = this.nativeGetFixedDisplayMode(this.env);
    }

    native DisplayMode nativeGetFixedDisplayMode(GdkGraphicsEnvironment var1);

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        if (this.idString == null) {
            this.idString = this.nativeGetIDString();
        }
        return this.idString;
    }

    private native String nativeGetIDString();

    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configurations.clone();
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configurations[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode getDisplayMode() {
        if (this.fixedDisplayMode != null) {
            return this.fixedDisplayMode;
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        int index = this.nativeGetDisplayModeIndex(this.env);
        int rate = this.nativeGetDisplayModeRate(this.env);
        return new DisplayMode(this.displayModes[index].width, this.displayModes[index].height, -1, rate);
    }

    native int nativeGetDisplayModeIndex(GdkGraphicsEnvironment var1);

    native int nativeGetDisplayModeRate(GdkGraphicsEnvironment var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getDisplayModes() {
        if (this.fixedDisplayMode != null) {
            return new DisplayMode[]{this.fixedDisplayMode};
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        ArrayList<DisplayMode> list2 = new ArrayList<DisplayMode>();
        int i = 0;
        while (i < this.displayModes.length) {
            int j = 0;
            while (j < this.displayModes[i].rates.length) {
                list2.add(new DisplayMode(this.displayModes[i].width, this.displayModes[i].height, -1, this.displayModes[i].rates[j]));
                ++j;
            }
            ++i;
        }
        return list2.toArray(new DisplayMode[list2.size()]);
    }

    native X11DisplayMode[] nativeGetDisplayModes(GdkGraphicsEnvironment var1);

    public boolean isFullScreenSupported() {
        return true;
    }

    public boolean isDisplayChangeSupported() {
        return this.fixedDisplayMode == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMode(DisplayMode dm) {
        if (this.fixedDisplayMode != null) {
            throw new UnsupportedOperationException("Cannnot change display mode.");
        }
        if (dm == null) {
            throw new IllegalArgumentException("DisplayMode must not be null.");
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        int i = 0;
        while (i < this.displayModes.length) {
            if (this.displayModes[i].width == dm.getWidth() && this.displayModes[i].height == dm.getHeight()) {
                GdkScreenGraphicsDevice gdkScreenGraphicsDevice2 = this;
                synchronized (gdkScreenGraphicsDevice2) {
                    this.nativeSetDisplayMode(this.env, i, (short)dm.getRefreshRate());
                    this.bounds = null;
                }
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Mode not supported by this device.");
    }

    native void nativeSetDisplayMode(GdkGraphicsEnvironment var1, int var2, short var3);

    public void setFullScreenWindow(Window w) {
        Frame f;
        if (this.fullscreenWindow != null && w != this.fullscreenWindow) {
            if (this.fullscreenWindow instanceof Frame && this.oldWindowDecorationState != (f = (Frame)this.fullscreenWindow).isUndecorated()) {
                f.dispose();
                f.setUndecorated(this.oldWindowDecorationState);
            }
            this.fullscreenWindow.setBounds(this.oldWindowBounds);
            if (!this.fullscreenWindow.isVisible()) {
                this.fullscreenWindow.setVisible(true);
            }
        }
        if (w != null) {
            if (w instanceof Frame) {
                f = (Frame)w;
                this.oldWindowDecorationState = f.isUndecorated();
                if (!this.oldWindowDecorationState) {
                    f.dispose();
                    f.setUndecorated(true);
                }
            }
            this.oldWindowBounds = w.getBounds();
            DisplayMode dm = this.getDisplayMode();
            w.setBounds(0, 0, dm.getWidth(), dm.getHeight());
            if (!w.isVisible()) {
                w.setVisible(true);
            }
            w.requestFocus();
            w.toFront();
        }
        this.fullscreenWindow = w;
    }

    public Window getFullScreenWindow() {
        return this.fullscreenWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle getBounds() {
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.bounds == null) {
                this.bounds = this.nativeGetBounds();
            }
        }
        return this.bounds;
    }

    native Rectangle nativeGetBounds();

    static class X11DisplayMode {
        short[] rates;
        int width;
        int height;

        X11DisplayMode(int width, int height, short[] rates) {
            this.width = width;
            this.height = height;
            this.rates = rates;
        }
    }
}

