/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.event.EventManager;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.event.filters.ClassExcludeFilter;
import gnu.classpath.jdwp.event.filters.ClassMatchFilter;
import gnu.classpath.jdwp.event.filters.ClassOnlyFilter;
import gnu.classpath.jdwp.event.filters.ConditionalFilter;
import gnu.classpath.jdwp.event.filters.CountFilter;
import gnu.classpath.jdwp.event.filters.ExceptionOnlyFilter;
import gnu.classpath.jdwp.event.filters.FieldOnlyFilter;
import gnu.classpath.jdwp.event.filters.IEventFilter;
import gnu.classpath.jdwp.event.filters.InstanceOnlyFilter;
import gnu.classpath.jdwp.event.filters.LocationOnlyFilter;
import gnu.classpath.jdwp.event.filters.StepFilter;
import gnu.classpath.jdwp.event.filters.ThreadOnlyFilter;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EventRequestCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeSet(bb, os);
                    break;
                }
                case 2: {
                    this.executeClear(bb, os);
                    break;
                }
                case 3: {
                    this.executeClearAllBreakpoints(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in EventRequest Reference Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeSet(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        byte eventKind = bb.get();
        byte suspendPolicy = bb.get();
        int modifiers = bb.getInt();
        switch (eventKind) {
            case 20: {
                String msg = "watching field accesses is not supported";
                throw new NotImplementedException(msg);
            }
            case 21: {
                String msg = "watching field modifications is not supported";
                throw new NotImplementedException(msg);
            }
        }
        EventRequest eventReq = new EventRequest(eventKind, suspendPolicy);
        IEventFilter filter = null;
        int i = 0;
        while (i < modifiers) {
            byte modKind = bb.get();
            switch (modKind) {
                case 1: {
                    filter = new CountFilter(bb.getInt());
                    break;
                }
                case 2: {
                    filter = new ConditionalFilter(this.idMan.readObjectId(bb));
                    break;
                }
                case 3: {
                    filter = new ThreadOnlyFilter((ThreadId)this.idMan.readObjectId(bb));
                    break;
                }
                case 4: {
                    filter = new ClassOnlyFilter(this.idMan.readReferenceTypeId(bb));
                    break;
                }
                case 5: {
                    filter = new ClassMatchFilter(JdwpString.readString(bb));
                    break;
                }
                case 6: {
                    filter = new ClassExcludeFilter(JdwpString.readString(bb));
                    break;
                }
                case 7: {
                    filter = new LocationOnlyFilter(new Location(bb));
                    break;
                }
                case 8: {
                    long id = bb.getLong();
                    ReferenceTypeId refId = id == 0L ? null : this.idMan.getReferenceType(id);
                    boolean caught = bb.get() != 0;
                    boolean unCaught = bb.get() != 0;
                    filter = new ExceptionOnlyFilter(refId, caught, unCaught);
                    break;
                }
                case 9: {
                    ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
                    ReferenceTypeId fieldId = this.idMan.readReferenceTypeId(bb);
                    filter = new FieldOnlyFilter(refId, fieldId);
                    break;
                }
                case 10: {
                    ThreadId tid = (ThreadId)this.idMan.readObjectId(bb);
                    int size = bb.getInt();
                    int depth = bb.getInt();
                    filter = new StepFilter(tid, size, depth);
                    break;
                }
                case 11: {
                    ObjectId oid = this.idMan.readObjectId(bb);
                    filter = new InstanceOnlyFilter(oid);
                    break;
                }
                default: {
                    throw new NotImplementedException("modKind " + modKind + " is not implemented.");
                }
            }
            eventReq.addFilter(filter);
            ++i;
        }
        EventManager.getDefault().requestEvent(eventReq);
        os.writeInt(eventReq.getId());
    }

    private void executeClear(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        byte eventKind = bb.get();
        int requestId = bb.getInt();
        EventManager.getDefault().deleteRequest(eventKind, requestId);
    }

    private void executeClearAllBreakpoints(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        byte eventKind = bb.get();
        EventManager.getDefault().clearRequests(eventKind);
    }
}

