/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;

class CertReqCmd
extends Command {
    private static final Logger log = Logger.getLogger(CertReqCmd.class.getName());
    private static final String ATTRIBUTES_OPT = "attributes";
    protected String _alias;
    protected String _sigAlgorithm;
    protected String _certReqFileName;
    protected String _password;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean nullAttributes;

    CertReqCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setSigalg(String algorithm) {
        this._sigAlgorithm = algorithm;
    }

    public void setFile(String pathName) {
        this._certReqFileName = pathName;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    public void setAttributes(String flag) {
        this.nullAttributes = Boolean.valueOf(flag);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(this._certReqFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordNoPrompt(this._password);
        if (Configuration.DEBUG) {
            log.fine("-certreq handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -sigalg=" + this._sigAlgorithm);
            log.fine("  -file=" + this._certReqFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
            log.fine("  -attributes=" + this.nullAttributes);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, IOException, UnsupportedCallbackException, UnrecoverableKeyException, InvalidKeyException, SignatureException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        Key privateKey = this.getAliasPrivateKey();
        Certificate[] chain = this.store.getCertificateChain(this.alias);
        X509Certificate bottomCertificate = (X509Certificate)chain[0];
        X500Principal aliasName = bottomCertificate.getIssuerX500Principal();
        PublicKey publicKey = bottomCertificate.getPublicKey();
        this.setSignatureAlgorithmParam(this._sigAlgorithm, privateKey);
        byte[] derBytes = this.getCSR(aliasName, publicKey, (PrivateKey)privateKey);
        String encoded = Base64.encode((byte[])derBytes, (int)72);
        PrintWriter writer = new PrintWriter(this.outStream, true);
        writer.println("-----BEGIN NEW CERTIFICATE REQUEST-----");
        writer.println(encoded);
        writer.println("-----END NEW CERTIFICATE REQUEST-----");
        if (this.verbose) {
            if (!this.systemOut) {
                System.out.println(Messages.getFormattedString("CertReqCmd.27", this._certReqFileName));
            }
            System.out.println(Messages.getString("CertReqCmd.28"));
        }
        writer.close();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("certreq", true);
        result.setHeader(Messages.getString("CertReqCmd.25"));
        result.setFooter(Messages.getString("CertReqCmd.24"));
        OptionGroup options = new OptionGroup(Messages.getString("CertReqCmd.23"));
        options.add(new Option("alias", Messages.getString("CertReqCmd.22"), Messages.getString("CertReqCmd.21")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._alias = argument;
            }
        });
        options.add(new Option("sigalg", Messages.getString("CertReqCmd.20"), Messages.getString("CertReqCmd.19")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._sigAlgorithm = argument;
            }
        });
        options.add(new Option("file", Messages.getString("CertReqCmd.18"), Messages.getString("CertReqCmd.17")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._certReqFileName = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("CertReqCmd.16"), Messages.getString("CertReqCmd.9")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._password = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("CertReqCmd.14"), Messages.getString("CertReqCmd.13")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("CertReqCmd.12"), Messages.getString("CertReqCmd.11")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("CertReqCmd.10"), Messages.getString("CertReqCmd.9")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("CertReqCmd.8"), Messages.getString("CertReqCmd.7")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("CertReqCmd.6")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this.verbose = true;
            }
        });
        options.add(new Option(ATTRIBUTES_OPT, Messages.getString("CertReqCmd.5")){

            public void parsed(String argument) throws OptionException {
                CertReqCmd.this.nullAttributes = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private byte[] getCSR(X500Principal aliasName, PublicKey publicKey, PrivateKey privateKey) throws IOException, InvalidKeyException, SignatureException {
        byte[] byArray;
        DERValue derVersion = new DERValue(2, (Object)BigInteger.ZERO);
        DERValue derSubject = new DERReader(aliasName.getEncoded()).read();
        DERValue derSubjectPKInfo = new DERReader(publicKey.getEncoded()).read();
        if (this.nullAttributes) {
            byte[] byArray2 = new byte[2];
            byArray = byArray2;
            byArray2[0] = 5;
        } else {
            byArray = new byte[]{};
        }
        byte[] b = byArray;
        DERValue derAttributes = new DERValue(160, b.length, (Object)b, null);
        ArrayList<DERValue> certRequestInfo = new ArrayList<DERValue>(4);
        certRequestInfo.add(derVersion);
        certRequestInfo.add(derSubject);
        certRequestInfo.add(derSubjectPKInfo);
        certRequestInfo.add(derAttributes);
        DERValue derCertRequestInfo = new DERValue(48, certRequestInfo);
        OID sigAlgorithmID = this.getSignatureAlgorithmOID();
        DERValue derSigAlgorithmID = new DERValue(6, (Object)sigAlgorithmID);
        ArrayList<DERValue> sigAlgorithm = new ArrayList<DERValue>(2);
        sigAlgorithm.add(derSigAlgorithmID);
        if (!sigAlgorithmID.equals((Object)Command.SHA1_WITH_DSA)) {
            sigAlgorithm.add(new DERValue(5, null));
        }
        sigAlgorithm.trimToSize();
        DERValue derSignatureAlgorithm = new DERValue(48, sigAlgorithm);
        this.signatureAlgorithm.initSign(privateKey);
        this.signatureAlgorithm.update(derCertRequestInfo.getEncoded());
        byte[] sigBytes = this.signatureAlgorithm.sign();
        DERValue derSignature = new DERValue(3, (Object)new BitString(sigBytes));
        ArrayList<DERValue> csr = new ArrayList<DERValue>(3);
        csr.add(derCertRequestInfo);
        csr.add(derSignatureAlgorithm);
        csr.add(derSignature);
        DERValue derCSR = new DERValue(48, csr);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DERWriter.write((OutputStream)baos, (DERValue)derCSR);
        byte[] result = baos.toByteArray();
        return result;
    }
}

