/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.BinaryExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantInteger;
import gnu.classpath.tools.gjdoc.expr.ConstantLong;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

abstract class BinaryBitwiseExpression
extends BinaryExpression {
    protected BinaryBitwiseExpression(Expression left, Expression right) {
        super(left, right);
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression leftValue = this.left.evaluate(context);
        ConstantExpression rightValue = this.right.evaluate(context);
        if (Type.LONG == leftValue.getType() || Type.LONG == rightValue.getType()) {
            return new ConstantLong(this.compute(leftValue.asNumber().longValue(), rightValue.asNumber().longValue()));
        }
        return new ConstantInteger(this.compute(leftValue.asNumber().intValue(), rightValue.asNumber().intValue()));
    }

    protected abstract long compute(long var1, long var3);

    protected abstract int compute(int var1, int var2);
}

