/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.menu;

import java.awt.Toolkit;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;

public class DebugMenu
extends JMenu {
    private static final Logger logger = Logger.getLogger(DebugMenu.class.getName());
    private static final String ERROR_MESSAGE = "This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred. This is a long error message, indicating that some error has occurred.";
    private final FreeColClient freeColClient;

    public DebugMenu(FreeColClient freeColClient) {
        super(Messages.message("menuBar.debug"));
        this.freeColClient = freeColClient;
        this.buildDebugMenu();
    }

    private void buildDebugMenu() {
        Game game = this.freeColClient.getGame();
        GUI gui = this.freeColClient.getGUI();
        boolean hasServer = this.freeColClient.getFreeColServer() != null;
        Player player = this.freeColClient.getMyPlayer();
        this.setOpaque(false);
        this.setMnemonic(68);
        this.add(this);
        JCheckBoxMenuItem sc = Utility.localizedCheckBoxMenuItem("menuBar.debug.showCoordinates", FreeColDebugger.debugDisplayCoordinates());
        sc.setOpaque(false);
        sc.setMnemonic(83);
        this.add(sc);
        sc.addActionListener(ae -> {
            boolean val = ((JCheckBoxMenuItem)ae.getSource()).isSelected();
            FreeColDebugger.setDebugDisplayCoordinates(val);
            gui.refresh();
        });
        sc.setEnabled(true);
        JCheckBoxMenuItem reveal = Utility.localizedCheckBoxMenuItem("menuBar.debug.revealEntireMap", false);
        reveal.setOpaque(false);
        reveal.setMnemonic(82);
        this.add(reveal);
        reveal.addActionListener(ae -> {
            DebugUtils.revealMap(this.freeColClient, true);
            reveal.setEnabled(false);
        });
        reveal.setEnabled(hasServer);
        JCheckBoxMenuItem hide = Utility.localizedCheckBoxMenuItem("menuBar.debug.hideEntireMap", false);
        hide.setOpaque(false);
        this.add(hide);
        hide.addActionListener(ae -> {
            DebugUtils.revealMap(this.freeColClient, false);
            hide.setEnabled(false);
        });
        hide.setEnabled(hasServer);
        JCheckBoxMenuItem searchTrace = Utility.localizedCheckBoxMenuItem("menuBar.debug.searchTrace", game.getMap().getSearchTrace());
        searchTrace.setOpaque(false);
        this.add(searchTrace);
        searchTrace.addActionListener(ae -> {
            boolean val = ((JCheckBoxMenuItem)ae.getSource()).isSelected();
            game.getMap().setSearchTrace(val);
        });
        JMenu cvpMenu = Utility.localizedMenu("menuBar.debug.showColonyValue");
        cvpMenu.setOpaque(false);
        ButtonGroup bg = new ButtonGroup();
        JRadioButtonMenuItem cv1 = Utility.localizedRadioButtonMenuItem(StringTemplate.template("none"), FreeColDebugger.debugDisplayColonyValuePlayer() == null);
        cv1.setOpaque(false);
        cv1.setMnemonic(67);
        cvpMenu.add(cv1);
        bg.add(cv1);
        cv1.addActionListener(ae -> {
            FreeColDebugger.setDebugDisplayColonyValuePlayer(null);
            gui.refresh();
        });
        this.add(cvpMenu);
        cvpMenu.addSeparator();
        for (Player p : game.getLiveEuropeanPlayers(null)) {
            JRadioButtonMenuItem cv2 = Utility.localizedRadioButtonMenuItem(p.getCountryLabel(), FreeColDebugger.debugDisplayColonyValuePlayer() == p);
            cv2.setOpaque(false);
            cvpMenu.add(cv2);
            bg.add(cv2);
            Player fp = p;
            cv2.addActionListener(ae -> {
                FreeColDebugger.setDebugDisplayColonyValuePlayer(fp);
                gui.refresh();
            });
        }
        this.addSeparator();
        JMenuItem skipTurns = Utility.localizedMenuItem("menuBar.debug.skipTurns");
        skipTurns.setOpaque(false);
        skipTurns.setMnemonic(84);
        this.add(skipTurns);
        skipTurns.addActionListener(ae -> DebugUtils.skipTurns(this.freeColClient));
        DebugUtils.addSkipChangeListener(this.freeColClient, this, skipTurns);
        skipTurns.setEnabled(hasServer);
        JMenuItem addBuilding = Utility.localizedMenuItem("menuBar.debug.addBuilding");
        addBuilding.setOpaque(false);
        addBuilding.setMnemonic(66);
        this.add(addBuilding);
        addBuilding.addActionListener(ae -> DebugUtils.addBuildings(this.freeColClient, addBuilding.getText()));
        addBuilding.setEnabled(hasServer);
        JMenuItem addFather = Utility.localizedMenuItem("menuBar.debug.addFoundingFather");
        addFather.setOpaque(false);
        addFather.setMnemonic(70);
        this.add(addFather);
        addFather.addActionListener(ae -> DebugUtils.addFathers(this.freeColClient, addFather.getText()));
        addFather.setEnabled(hasServer);
        JMenuItem runMonarch = Utility.localizedMenuItem("menuBar.debug.runMonarch");
        runMonarch.setOpaque(false);
        runMonarch.setMnemonic(77);
        this.add(runMonarch);
        runMonarch.addActionListener(ae -> DebugUtils.setMonarchAction(this.freeColClient, runMonarch.getText()));
        runMonarch.setEnabled(hasServer);
        JMenuItem addGold = Utility.localizedMenuItem("menuBar.debug.addGold");
        addGold.setOpaque(false);
        addGold.setMnemonic(71);
        this.add(addGold);
        addGold.addActionListener(ae -> DebugUtils.addGold(this.freeColClient));
        addGold.setEnabled(hasServer);
        JMenuItem addCrosses = Utility.localizedMenuItem("menuBar.debug.addImmigration");
        addCrosses.setOpaque(false);
        addCrosses.setMnemonic(73);
        this.add(addCrosses);
        addCrosses.addActionListener(ae -> DebugUtils.addImmigration(this.freeColClient));
        addCrosses.setEnabled(hasServer);
        JMenuItem giveBells = Utility.localizedMenuItem("menuBar.debug.addLiberty");
        giveBells.setOpaque(false);
        giveBells.setMnemonic(76);
        this.add(giveBells);
        giveBells.addActionListener(ae -> DebugUtils.addLiberty(this.freeColClient));
        giveBells.setEnabled(hasServer);
        JMenuItem rng = Utility.localizedMenuItem("menuBar.debug.stepRandomNumberGenerator");
        rng.setOpaque(false);
        rng.setMnemonic(88);
        this.add(rng);
        rng.addActionListener(ae -> DebugUtils.stepRNG(this.freeColClient));
        rng.setEnabled(hasServer);
        JMenuItem du = Utility.localizedMenuItem("menuBar.debug.displayUnits");
        du.setOpaque(false);
        this.add(du);
        du.addActionListener(ae -> DebugUtils.displayUnits(this.freeColClient));
        du.setEnabled(true);
        this.addSeparator();
        JMenu panelMenu = Utility.localizedMenu("menuBar.debug.displayPanels");
        panelMenu.setOpaque(false);
        JMenuItem monarchDialog = Utility.localizedMenuItem("menuBar.debug.displayMonarchPanel");
        monarchDialog.addActionListener(ae -> gui.showMonarchDialog(Monarch.MonarchAction.RAISE_TAX_WAR, null, player.getMonarchKey(), b -> this.freeColClient.getInGameController().monarchAction(Monarch.MonarchAction.RAISE_TAX_WAR, (boolean)b)));
        panelMenu.add(monarchDialog);
        JMenuItem errorMessage = Utility.localizedMenuItem("menuBar.debug.displayErrorMessage");
        errorMessage.addActionListener(ae -> gui.showErrorMessage(ERROR_MESSAGE));
        panelMenu.add(errorMessage);
        this.add(panelMenu);
        JMenuItem europeStatus = Utility.localizedMenuItem("menuBar.debug.displayEuropeStatus");
        europeStatus.setOpaque(false);
        europeStatus.setMnemonic(69);
        this.add(europeStatus);
        europeStatus.addActionListener(ae -> DebugUtils.displayEurope(this.freeColClient));
        europeStatus.setEnabled(hasServer);
        JCheckBoxMenuItem dam = Utility.localizedCheckBoxMenuItem("menuBar.debug.displayAIMissions", FreeColDebugger.debugShowMission());
        JCheckBoxMenuItem dami = Utility.localizedCheckBoxMenuItem("menuBar.debug.displayAdditionalAIMissionInfo", FreeColDebugger.debugShowMissionInfo());
        dam.setOpaque(false);
        dam.setMnemonic(65);
        this.add(dam);
        dam.addActionListener(ae -> {
            boolean val = ((JCheckBoxMenuItem)ae.getSource()).isSelected();
            FreeColDebugger.setDebugShowMission(val);
            dami.setEnabled(val);
            gui.refresh();
        });
        dam.setEnabled(true);
        JMenuItem useAI = Utility.localizedMenuItem("menuBar.debug.useAI");
        useAI.setOpaque(false);
        useAI.setMnemonic(65);
        useAI.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(useAI);
        useAI.addActionListener(ae -> DebugUtils.useAI(this.freeColClient));
        useAI.setEnabled(hasServer);
        dami.setOpaque(false);
        dami.setMnemonic(73);
        this.add(dami);
        dami.addActionListener(ae -> {
            boolean val = ((JCheckBoxMenuItem)ae.getSource()).isSelected();
            FreeColDebugger.setDebugShowMissionInfo(val);
            dami.setEnabled(val);
            gui.refresh();
        });
        dami.setEnabled(FreeColDebugger.debugShowMissionInfo());
        this.addSeparator();
        JMenuItem compareMaps = Utility.localizedMenuItem("menuBar.debug.compareMaps");
        compareMaps.setOpaque(false);
        compareMaps.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        this.add(compareMaps);
        compareMaps.addActionListener(ae -> DebugUtils.checkDesyncAction(this.freeColClient));
        compareMaps.setEnabled(hasServer);
        JMenuItem showResourceKeys = Utility.localizedMenuItem("menuBar.debug.showResourceKeys");
        showResourceKeys.setOpaque(false);
        this.add(showResourceKeys);
        showResourceKeys.addActionListener(ae -> {
            StringBuilder builder = new StringBuilder();
            Map<String, ImageResource> resources = ResourceManager.getImageResources();
            for (Map.Entry<String, ImageResource> en : CollectionUtils.mapEntriesByKey(resources)) {
                builder.append(en.getKey());
                builder.append(" (");
                builder.append(en.getValue().getCount());
                builder.append(")");
                builder.append("\n");
            }
            gui.showInformationMessage(builder.toString());
        });
        showResourceKeys.setEnabled(true);
        JMenuItem statistics = Utility.localizedMenuItem("statistics");
        statistics.setOpaque(false);
        this.add(statistics);
        statistics.addActionListener(ae -> gui.showStatisticsPanel());
        statistics.setEnabled(true);
        JMenuItem gc = Utility.localizedMenuItem("menuBar.debug.memoryManager.gc");
        gc.setOpaque(false);
        this.add(gc);
        gc.addActionListener(ae -> System.gc());
        gc.setEnabled(true);
        this.addSeparator();
    }
}

