/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.DialogHandler;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.GUIMessage;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.client.gui.MapViewer;
import net.sf.freecol.client.gui.OutForAnimationCallback;
import net.sf.freecol.client.gui.TileViewer;
import net.sf.freecol.client.gui.animation.Animations;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.ColorChooserPanel;
import net.sf.freecol.client.gui.panel.CornerMapControls;
import net.sf.freecol.client.gui.panel.FreeColDialog;
import net.sf.freecol.client.gui.panel.LabourData;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.Parameters;
import net.sf.freecol.client.gui.panel.TradeRoutePanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.gui.video.VideoComponent;
import net.sf.freecol.client.gui.video.VideoListener;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.ServerInfo;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighScore;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.option.BooleanOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.util.StringUtils;

public class SwingGUI
extends GUI {
    private final GraphicsDevice graphicsDevice = SwingGUI.getGoodGraphicsDevice();
    private TileViewer tileViewer;
    private MapViewer mapViewer;
    private Canvas canvas;
    private MapControls mapControls;
    private JWindow splash;

    public SwingGUI(FreeColClient freeColClient, float scaleFactor) {
        super(freeColClient, scaleFactor);
        logger.info("GUI constructed using scale factor " + scaleFactor);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public ImageLibrary getTileImageLibrary() {
        return this.tileViewer.getImageLibrary();
    }

    @Override
    public boolean isWindowed() {
        return this.canvas.isWindowed();
    }

    @Override
    public void installLookAndFeel(String fontName) throws FreeColException {
        FreeColLookAndFeel fclaf = new FreeColLookAndFeel();
        FreeColLookAndFeel.install(fclaf);
        Font font = FontLibrary.createMainFont(fontName, this.imageLibrary.getScaleFactor());
        FreeColLookAndFeel.installFont(font);
        Utility.initStyleContext(font);
    }

    @Override
    public void quit() throws Exception {
        if (this.canvas != null) {
            this.canvas.quit();
        }
    }

    @Override
    public void initializeInGame(Tile tile) {
        this.canvas.initializeInGame();
        this.enableMapControls(this.freeColClient.getClientOptions().getBoolean("model.option.displayMapControls"));
        this.setSelectedTile(tile);
    }

    @Override
    public void setupMouseListeners() {
        this.canvas.setupMouseListeners();
    }

    @Override
    public void displaySplashScreen(InputStream splashStream) {
        this.splash = null;
        if (splashStream == null) {
            return;
        }
        try {
            BufferedImage im = ImageIO.read(splashStream);
            this.splash = new JWindow(this.graphicsDevice.getDefaultConfiguration());
            this.splash.getContentPane().add(new JLabel(new ImageIcon(im)));
            this.splash.pack();
            Point start = this.splash.getLocation();
            DisplayMode dm = this.graphicsDevice.getDisplayMode();
            this.splash.setLocation(start.x + dm.getWidth() / 2 - this.splash.getWidth() / 2, start.y + dm.getHeight() / 2 - this.splash.getHeight() / 2);
            this.splash.setVisible(true);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Splash fail", e);
            this.splash = null;
        }
    }

    @Override
    public void hideSplashScreen() {
        if (this.splash != null) {
            this.splash.setVisible(false);
            this.splash.dispose();
            this.splash = null;
        }
    }

    @Override
    public void showOpeningVideo(final String userMsg) {
        this.canvas.closeMenus();
        Video video = ResourceManager.getVideo("video.opening");
        boolean muteAudio = !this.freeColClient.getSoundController().canPlaySound();
        final VideoComponent vp = new VideoComponent(video, muteAudio);
        final class AbortListener
        implements ActionListener,
        KeyListener,
        MouseListener,
        VideoListener {
            private Timer t = null;

            AbortListener() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e1) {
                this.execute();
            }

            @Override
            public void keyTyped(KeyEvent e2) {
            }

            @Override
            public void mouseClicked(MouseEvent e3) {
                this.execute();
            }

            @Override
            public void mouseEntered(MouseEvent e4) {
            }

            @Override
            public void mouseExited(MouseEvent e5) {
            }

            @Override
            public void mousePressed(MouseEvent e6) {
            }

            @Override
            public void mouseReleased(MouseEvent e7) {
            }

            @Override
            public void stopped() {
                this.execute();
            }

            @Override
            public void actionPerformed(ActionEvent ae8) {
                this.execute();
            }

            private void setTimer(Timer t1) {
                this.t = t1;
            }

            private void execute() {
                SwingGUI.this.canvas.removeKeyListener(this);
                SwingGUI.this.canvas.removeMouseListener(this);
                vp.removeMouseListener(this);
                vp.stop();
                SwingGUI.this.canvas.remove(vp);
                if (this.t != null) {
                    this.t.stop();
                }
                SwingGUI.this.playSound("sound.intro.general");
                SwingGUI.this.showMainPanel(userMsg);
            }
        }
        AbortListener l = new AbortListener();
        vp.addMouseListener(l);
        this.canvas.showVideoComponent(vp, l, l);
        vp.play();
        Timer t2 = new Timer(80000, l);
        l.setTimer(t2);
        t2.setRepeats(false);
        t2.start();
    }

    private static GraphicsDevice getGoodGraphicsDevice() {
        try {
            return MouseInfo.getPointerInfo().getDevice();
        }
        catch (HeadlessException headlessException) {
            try {
                GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                return lge.getDefaultScreenDevice();
            }
            catch (HeadlessException headlessException2) {
                FreeColClient.fatal("Could not find a GraphicsDevice!");
                return null;
            }
        }
    }

    @Override
    public void startGUI(Dimension desiredWindowSize) {
        ClientOptions opts = this.freeColClient.getClientOptions();
        String pmoffscreen = "sun.java2d.pmoffscreen";
        BooleanOption usePixmaps = (BooleanOption)opts.getOption("model.option.usePixmaps");
        String pmoffscreenValue = System.getProperty("sun.java2d.pmoffscreen");
        if (pmoffscreenValue == null) {
            System.setProperty("sun.java2d.pmoffscreen", usePixmaps.getValue().toString());
            logger.info("sun.java2d.pmoffscreen using client option: " + usePixmaps.getValue());
        } else {
            usePixmaps.setValue(Boolean.valueOf(pmoffscreenValue));
            logger.info("sun.java2d.pmoffscreen overrides client option: " + pmoffscreenValue);
        }
        usePixmaps.addPropertyChangeListener(e -> {
            String newValue = e.getNewValue().toString();
            System.setProperty("sun.java2d.pmoffscreen", newValue);
            logger.info("Set sun.java2d.pmoffscreen to: " + newValue);
        });
        this.mapViewer = new MapViewer(this.freeColClient);
        this.canvas = new Canvas(this.freeColClient, this.graphicsDevice, this, desiredWindowSize, this.mapViewer);
        this.tileViewer = new TileViewer(this.freeColClient);
        LanguageOption o = (LanguageOption)this.freeColClient.getClientOptions().getOption("model.option.languageOption");
        o.addPropertyChangeListener(e -> {
            LanguageOption.Language language = (LanguageOption.Language)e.getNewValue();
            logger.info("Set language to: " + language);
            if ("automatic".equalsIgnoreCase(language.getKey())) {
                this.showInformationMessage("info.autodetectLanguageSelected");
            } else {
                Locale l = language.getLocale();
                Messages.loadMessageBundle(l);
                Messages.loadModMessageBundle(l);
                this.showInformationMessage(StringTemplate.template("info.newLanguageSelected").addName("%language%", l.getDisplayName()));
            }
        });
        logger.info("GUI created.");
        logger.info("Starting in Move Units View Mode");
    }

    @Override
    public void changeWindowedMode() {
        this.canvas.changeWindowedMode();
    }

    @Override
    public void startMapEditorGUI() {
        this.canvas.startMapEditorGUI();
    }

    @Override
    public void activateGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null) {
            return;
        }
        if (this.canvas.isGotoStarted()) {
            this.canvas.stopGoto();
        } else {
            Tile tile;
            this.canvas.startGoto();
            Point pt = this.canvas.getMousePosition();
            if (pt != null && (tile = this.canvas.convertToMapTile(pt.x, pt.y)) != null && unit.getTile() != tile) {
                this.canvas.setGotoPath(unit.findPath(tile));
            }
        }
    }

    @Override
    public void clearGotoPath() {
        Unit unit = this.getActiveUnit();
        if (unit == null) {
            return;
        }
        this.canvas.stopGoto();
    }

    @Override
    public void displayChatMessage(Player player, String message, boolean privateChat) {
        this.canvas.displayChatMessage(new GUIMessage(player.getName() + ": " + message, player.getNationColor()));
    }

    @Override
    public void refresh() {
        this.mapViewer.forceReposition();
        this.canvas.refresh();
    }

    public void refreshTile(Tile tile) {
        if (tile.getX() >= 0 && tile.getY() >= 0) {
            this.canvas.repaint(this.mapViewer.calculateTileBounds(tile));
        }
    }

    @Override
    public void resetMenuBar() {
        this.freeColClient.updateActions();
        this.canvas.resetMenuBar();
    }

    @Override
    protected void resetMapZoom() {
        super.resetMapZoom();
        this.mapViewer.resetMapScale();
        this.refresh();
    }

    @Override
    public boolean canZoomInMap() {
        return !this.mapViewer.isAtMaxMapScale();
    }

    @Override
    public boolean canZoomOutMap() {
        return !this.mapViewer.isAtMinMapScale();
    }

    @Override
    public void zoomInMap() {
        super.zoomInMap();
        this.mapViewer.increaseMapScale();
        this.refresh();
    }

    @Override
    public void zoomOutMap() {
        super.zoomOutMap();
        this.mapViewer.decreaseMapScale();
        this.refresh();
    }

    @Override
    public boolean setActiveUnit(Unit unit) {
        boolean result = this.mapViewer.setActiveUnit(unit);
        this.updateMapControls();
        this.updateMenuBar();
        if (unit != null && !this.freeColClient.getMyPlayer().owns(unit)) {
            this.canvas.refresh();
        }
        return result;
    }

    @Override
    public void updateMenuBar() {
        this.freeColClient.updateActions();
        this.canvas.updateMenuBar();
    }

    @Override
    public boolean requireFocus(Tile tile) {
        boolean required = this.freeColClient.getClientOptions().getBoolean("model.option.alwaysCenter");
        if (required && tile != this.getFocus() || !this.mapViewer.onScreen(tile)) {
            this.setFocusImmediately(tile);
            return true;
        }
        return false;
    }

    @Override
    public void animateUnitAttack(Unit attacker, Unit defender, Tile attackerTile, Tile defenderTile, boolean success) {
        this.requireFocus(attackerTile);
        Animations.unitAttack(this.freeColClient, attacker, defender, attackerTile, defenderTile, success);
    }

    @Override
    public void animateUnitMove(Unit unit, Tile srcTile, Tile dstTile) {
        this.requireFocus(srcTile);
        Animations.unitMove(this.freeColClient, unit, srcTile, dstTile);
    }

    @Override
    public void enableMapControls(boolean enable) {
        if (enable && this.mapControls == null) {
            String className = this.freeColClient.getClientOptions().getString("model.option.mapControls");
            try {
                String panelName = "net.sf.freecol.client.gui.panel." + StringUtils.lastPart(className, ".");
                Class<?> controls = Class.forName(panelName);
                this.mapControls = (MapControls)controls.getConstructor(FreeColClient.class).newInstance(this.freeColClient);
                logger.info("Instantiated " + panelName);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Fallback to CornerMapControls from " + className, e);
                this.mapControls = new CornerMapControls(this.freeColClient);
            }
            if (this.mapControls != null) {
                this.mapControls.addToComponent(this.canvas);
                this.mapControls.update();
            }
        } else if (!enable && this.mapControls != null) {
            this.mapControls.removeFromComponent(this.canvas);
            this.mapControls = null;
        }
    }

    @Override
    public void updateMapControls() {
        if (this.mapControls != null) {
            this.mapControls.update();
        }
    }

    public void updateMapControlsInCanvas() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.removeFromComponent(this.canvas);
        this.mapControls.addToComponent(this.canvas);
    }

    @Override
    public void zoomInMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomIn();
    }

    @Override
    public void zoomOutMapControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.zoomOut();
    }

    @Override
    public boolean canZoomInMapControls() {
        return this.mapControls != null && this.mapControls.canZoomInMapControls();
    }

    @Override
    public boolean canZoomOutMapControls() {
        return this.mapControls != null && this.mapControls.canZoomOutMapControls();
    }

    @Override
    public void miniMapToggleViewControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.toggleView();
    }

    @Override
    public void miniMapToggleFogOfWarControls() {
        if (this.mapControls == null) {
            return;
        }
        this.mapControls.toggleFogOfWar();
    }

    @Override
    public boolean confirm(String textKey, String okKey, String cancelKey) {
        return this.canvas.showConfirmDialog(null, Messages.message(textKey), null, okKey, cancelKey);
    }

    @Override
    public boolean confirm(Tile tile, StringTemplate template, String okKey, String cancelKey) {
        return this.canvas.showConfirmDialog(tile, Utility.localizedTextArea(template), null, okKey, cancelKey);
    }

    @Override
    public boolean confirm(Tile tile, StringTemplate template, Unit unit, String okKey, String cancelKey) {
        return this.canvas.showConfirmDialog(tile, Utility.localizedTextArea(template), new ImageIcon(this.imageLibrary.getUnitImage(unit)), okKey, cancelKey);
    }

    @Override
    public boolean confirm(Tile tile, StringTemplate template, Settlement settlement, String okKey, String cancelKey) {
        return this.canvas.showConfirmDialog(tile, Utility.localizedTextArea(template), new ImageIcon(this.imageLibrary.getSettlementImage(settlement)), okKey, cancelKey);
    }

    @Override
    public boolean confirm(Tile tile, StringTemplate template, GoodsType goodsType, String okKey, String cancelKey) {
        return this.canvas.showConfirmDialog(tile, Utility.localizedTextArea(template), new ImageIcon(this.imageLibrary.getIconImage(goodsType)), okKey, cancelKey);
    }

    @Override
    public List<String> confirmDeclaration() {
        return this.canvas.showConfirmDeclarationDialog();
    }

    @Override
    public <T> T getChoice(Tile tile, Object explain, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, explain, null, cancelKey, choices);
    }

    @Override
    public <T> T getChoice(Tile tile, Object explain, Unit unit, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, explain, new ImageIcon(this.imageLibrary.getUnitImage(unit)), cancelKey, choices);
    }

    @Override
    public <T> T getChoice(Tile tile, Object explain, Settlement settlement, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, explain, new ImageIcon(this.imageLibrary.getSettlementImage(settlement)), cancelKey, choices);
    }

    @Override
    public <T> T getChoice(Tile tile, Object explain, GoodsType goodsType, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, explain, new ImageIcon(this.imageLibrary.getIconImage(goodsType)), cancelKey, choices);
    }

    @Override
    public <T> T getChoice(Tile tile, Object explain, Nation nation, String cancelKey, List<ChoiceItem<T>> choices) {
        return this.canvas.showChoiceDialog(tile, explain, new ImageIcon(this.imageLibrary.getMiscIconImage(nation)), cancelKey, choices);
    }

    @Override
    public String getInput(Tile tile, StringTemplate template, String defaultValue, String okKey, String cancelKey) {
        return this.canvas.showInputDialog(tile, template, defaultValue, okKey, cancelKey);
    }

    @Override
    public void closeMainPanel() {
        this.canvas.closeMainPanel();
    }

    @Override
    public void closeMenus() {
        this.canvas.closeMenus();
    }

    @Override
    public void closeStatusPanel() {
        this.canvas.closeStatusPanel();
    }

    @Override
    public boolean containsInGameComponents() {
        return this.canvas.containsInGameComponents();
    }

    public void dialogRemove(FreeColDialog<?> fcd) {
        this.canvas.dialogRemove(fcd);
    }

    public void displayObject(FreeColObject fco) {
        if (fco instanceof Colony) {
            this.canvas.showColonyPanel((Colony)fco, null);
        } else if (fco instanceof Europe) {
            this.canvas.showEuropePanel();
        } else if (fco instanceof IndianSettlement) {
            this.canvas.showIndianSettlementPanel((IndianSettlement)fco);
        } else if (fco instanceof Tile) {
            this.setFocus((Tile)fco);
        } else if (fco instanceof Unit) {
            Location loc = ((Unit)fco).up();
            if (loc instanceof Colony) {
                this.canvas.showColonyPanel((Colony)loc, (Unit)fco);
            } else {
                this.displayObject((FreeColObject)((Object)loc));
            }
        } else if (fco instanceof WorkLocation) {
            this.canvas.showColonyPanel(((WorkLocation)fco).getColony(), null);
        }
    }

    @Override
    public LoadingSavegameInfo getLoadingSavegameInfo() {
        return this.canvas.getLoadingSavegameDialog().getInfo();
    }

    @Override
    public boolean isClientOptionsDialogShowing() {
        return this.canvas != null && this.canvas.isClientOptionsDialogShowing();
    }

    @Override
    public boolean isMapboardActionsEnabled() {
        return this.canvas != null && this.canvas.isMapboardActionsEnabled();
    }

    @Override
    public boolean isShowingSubPanel() {
        return this.canvas != null && this.canvas.isShowingSubPanel();
    }

    @Override
    public void paintImmediatelyCanvasIn(Rectangle rectangle) {
        this.canvas.paintImmediately(rectangle);
    }

    @Override
    public void paintImmediatelyCanvasInItsBounds() {
        this.canvas.paintImmediately(this.canvas.getBounds());
    }

    @Override
    public void refreshPlayersTable() {
        this.canvas.refreshPlayersTable();
    }

    public void removeFromCanvas(Component component) {
        this.canvas.remove(component);
    }

    @Override
    public void removeInGameComponents() {
        this.canvas.removeInGameComponents();
    }

    public void removeTradeRoutePanel(TradeRoutePanel panel) {
        this.canvas.removeTradeRoutePanel(panel);
    }

    @Override
    public void requestFocusForSubPanel() {
        this.canvas.getShowingSubPanel().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.canvas.requestFocusInWindow();
    }

    public void restoreSavedSize(Component comp, int w, int h) {
        this.canvas.restoreSavedSize(comp, new Dimension(w, h));
    }

    public void restoreSavedSize(Component comp, Dimension size) {
        this.canvas.restoreSavedSize(comp, size);
    }

    @Override
    public void returnToTitle() {
        this.canvas.returnToTitle();
        this.playSound("sound.intro.general");
    }

    @Override
    public void showAboutPanel() {
        this.canvas.showAboutPanel();
    }

    public void showBuildQueuePanel(Colony colony) {
        this.canvas.showBuildQueuePanel(colony);
    }

    public void showBuildQueuePanel(Colony colony, Runnable callBack) {
        this.canvas.showBuildQueuePanel(colony, callBack);
    }

    @Override
    public void showCaptureGoodsDialog(Unit unit, List<Goods> gl, DialogHandler<List<Goods>> handler) {
        this.canvas.showCaptureGoodsDialog(unit, gl, handler);
    }

    @Override
    public void showChatPanel() {
        this.canvas.showChatPanel();
    }

    @Override
    public void showChooseFoundingFatherDialog(List<FoundingFather> ffs, DialogHandler<FoundingFather> handler) {
        this.canvas.showChooseFoundingFatherDialog(ffs, handler);
    }

    @Override
    public void showClientOptionsDialog() {
        OptionGroup group = null;
        try {
            group = this.canvas.showClientOptionsDialog();
        }
        finally {
            if (group != null) {
                this.resetMenuBar();
                this.updateMapControls();
            }
        }
        if (!this.freeColClient.isInGame()) {
            this.showMainPanel(null);
        }
    }

    @Override
    protected void showForeignColony(Settlement settlement) {
        this.canvas.showForeignColony(settlement);
    }

    @Override
    public void showColonyPanel(Colony colony, Unit unit) {
        this.canvas.showColonyPanel(colony, unit);
    }

    public ColonyPanel showColonyPanel2(Colony colony, Unit unit) {
        return this.canvas.showColonyPanel(colony, unit);
    }

    @Override
    public void showColopediaPanel(String nodeId) {
        this.canvas.showColopediaPanel(nodeId);
    }

    public ColorChooserPanel showColorChooserPanel(ActionListener al) {
        return this.canvas.showColorChooserPanel(al);
    }

    @Override
    public void showCompactLabourReport() {
        this.canvas.showCompactLabourReport();
    }

    public void showCompactLabourReport(LabourData.UnitData unitData) {
        this.canvas.showCompactLabourReport(unitData);
    }

    @Override
    public void showDeclarationPanel() {
        this.canvas.showDeclarationPanel();
    }

    @Override
    public OptionGroup showDifficultyDialog() {
        Game game = this.freeColClient.getGame();
        Specification spec = game.getSpecification();
        return this.canvas.showDifficultyDialog(spec, spec.getDifficultyOptionGroup(), false);
    }

    public OptionGroup showDifficultyDialog(Specification spec, OptionGroup group) {
        return this.canvas.showDifficultyDialog(spec, group, group.isEditable());
    }

    @Override
    public void showDumpCargoDialog(Unit unit, DialogHandler<List<Goods>> handler) {
        this.canvas.showDumpCargoDialog(unit, handler);
    }

    @Override
    public boolean showEditOptionDialog(Option option) {
        return this.canvas.showEditOptionDialog(option);
    }

    @Override
    public void showEmigrationDialog(Player player, boolean fountainOfYouth, DialogHandler<Integer> handler) {
        this.canvas.showEmigrationDialog(player, fountainOfYouth, handler);
    }

    @Override
    public void showEndTurnDialog(List<Unit> units, DialogHandler<Boolean> handler) {
        this.canvas.showEndTurnDialog(units, handler);
    }

    @Override
    public void showErrorMessage(StringTemplate template) {
        this.canvas.showErrorMessage(Messages.message(template));
    }

    @Override
    public void showErrorMessage(String messageId) {
        this.canvas.showErrorMessage(messageId);
    }

    @Override
    public void showErrorMessage(String messageID, String message) {
        this.canvas.showErrorMessage(messageID, message);
    }

    @Override
    public void showEuropePanel() {
        this.canvas.showEuropePanel();
    }

    @Override
    public void showEventPanel(String header, String image, String footer) {
        this.canvas.showEventPanel(header, image, footer);
    }

    @Override
    public void showFindSettlementPanel() {
        this.canvas.showFindSettlementPanel();
    }

    @Override
    public OptionGroup showGameOptionsDialog(boolean editable, boolean custom) {
        return this.canvas.showGameOptionsDialog(editable, custom);
    }

    @Override
    public void showHighScoresPanel(String messageId, List<HighScore> scores) {
        this.canvas.showHighScoresPanel(messageId, scores);
    }

    @Override
    public void showIndianSettlementPanel(IndianSettlement indianSettlement) {
        this.canvas.showIndianSettlementPanel(indianSettlement);
    }

    @Override
    public void showInformationMessage(String messageId) {
        super.showInformationMessage(messageId);
        this.canvas.showInformationMessage(null, null, null, StringTemplate.key(messageId));
    }

    @Override
    public void showInformationMessage(StringTemplate template) {
        super.showInformationMessage(template);
        this.canvas.showInformationMessage(null, null, null, template);
    }

    @Override
    public void showInformationMessage(Settlement displayObject, StringTemplate template) {
        super.showInformationMessage(displayObject, template);
        ImageIcon icon = null;
        Tile tile = null;
        if (displayObject != null) {
            icon = new ImageIcon(this.imageLibrary.getSettlementImage(displayObject));
            tile = displayObject.getTile();
        }
        this.canvas.showInformationMessage(displayObject, tile, icon, template);
    }

    @Override
    public void showInformationMessage(Unit displayObject, StringTemplate template) {
        super.showInformationMessage(displayObject, template);
        ImageIcon icon = null;
        Tile tile = null;
        if (displayObject != null) {
            icon = new ImageIcon(this.imageLibrary.getUnitImage(displayObject));
            tile = displayObject.getTile();
        }
        this.canvas.showInformationMessage(displayObject, tile, icon, template);
    }

    @Override
    public void showInformationMessage(Tile displayObject, StringTemplate template) {
        super.showInformationMessage(displayObject, template);
        this.canvas.showInformationMessage(displayObject, displayObject, null, template);
    }

    @Override
    public void showInformationMessage(FreeColObject displayObject, String messageId) {
        super.showInformationMessage(displayObject, messageId);
        this.canvas.showInformationMessage(displayObject, StringTemplate.key(messageId));
    }

    @Override
    public void showInformationMessage(FreeColObject displayObject, StringTemplate template) {
        super.showInformationMessage(displayObject, template);
        this.canvas.showInformationMessage(displayObject, template);
    }

    @Override
    public File showLoadDialog(File directory) {
        return this.canvas.showLoadDialog(directory, null);
    }

    public File showLoadDialog(File directory, FileFilter[] fileFilters) {
        return this.canvas.showLoadDialog(directory, fileFilters);
    }

    @Override
    public boolean showLoadingSavegameDialog(boolean publicServer, boolean singlePlayer) {
        return this.canvas.showLoadingSavegameDialog(publicServer, singlePlayer);
    }

    @Override
    public void showLogFilePanel() {
        this.canvas.showLogFilePanel();
    }

    @Override
    public void showMainPanel(String userMsg) {
        this.canvas.showMainPanel(userMsg);
    }

    @Override
    public OptionGroup showMapGeneratorOptionsDialog(boolean editable) {
        return this.canvas.showMapGeneratorOptionsDialog(editable);
    }

    @Override
    public Dimension showMapSizeDialog() {
        return this.canvas.showMapSizeDialog();
    }

    @Override
    public void showModelMessages(List<ModelMessage> modelMessages) {
        this.canvas.showModelMessages(modelMessages);
    }

    @Override
    public void showMonarchDialog(Monarch.MonarchAction action, StringTemplate template, String monarchKey, DialogHandler<Boolean> handler) {
        this.canvas.showMonarchDialog(action, template, monarchKey, handler);
    }

    @Override
    public void showNamingDialog(StringTemplate template, String defaultName, Unit unit, DialogHandler<String> handler) {
        this.canvas.showNamingDialog(template, defaultName, unit, handler);
    }

    @Override
    public void showFirstContactDialog(Player player, Player other, Tile tile, int settlementCount, DialogHandler<Boolean> handler) {
        this.canvas.showFirstContactDialog(player, other, tile, settlementCount, handler);
    }

    @Override
    public DiplomaticTrade showNegotiationDialog(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade agreement, StringTemplate comment) {
        return this.canvas.showNegotiationDialog(our, other, agreement, comment);
    }

    @Override
    public void showNewPanel() {
        this.canvas.showNewPanel(null);
    }

    @Override
    public void showNewPanel(Specification specification) {
        this.canvas.showNewPanel(specification);
    }

    @Override
    public void showSpyColonyPanel(Tile tile, Runnable callback) {
        ColonyPanel panel = this.canvas.showSpyColonyPanel(tile);
        panel.addClosingCallback(callback);
    }

    @Override
    public Parameters showParametersDialog() {
        return this.canvas.showParametersDialog();
    }

    @Override
    public boolean showPreCombatDialog(Unit attacker, FreeColGameObject defender, Tile tile) {
        return this.canvas.showPreCombatDialog(attacker, defender, tile);
    }

    public void showPurchasePanel() {
        this.canvas.showPurchasePanel();
    }

    public void showRecruitPanel() {
        this.canvas.showRecruitPanel();
    }

    @Override
    public void showReportCargoPanel() {
        this.canvas.showReportCargoPanel();
    }

    @Override
    public void showReportColonyPanel() {
        this.canvas.showReportColonyPanel();
    }

    @Override
    public void showReportContinentalCongressPanel() {
        this.canvas.showReportContinentalCongressPanel();
    }

    @Override
    public void showReportEducationPanel() {
        this.canvas.showReportEducationPanel();
    }

    @Override
    public void showReportExplorationPanel() {
        this.canvas.showReportExplorationPanel();
    }

    @Override
    public void showReportForeignAffairPanel() {
        this.canvas.showReportForeignAffairPanel();
    }

    @Override
    public void showReportHistoryPanel() {
        this.canvas.showReportHistoryPanel();
    }

    @Override
    public void showReportIndianPanel() {
        this.canvas.showReportIndianPanel();
    }

    public void showReportLabourDetailPanel(UnitType unitType, Map<UnitType, Map<Location, Integer>> data, TypeCountMap<UnitType> unitCount, List<Colony> colonies) {
        this.canvas.showReportLabourDetailPanel(unitType, data, unitCount, colonies);
    }

    @Override
    public void showReportLabourPanel() {
        this.canvas.showReportLabourPanel();
    }

    @Override
    public void showReportMilitaryPanel() {
        this.canvas.showReportMilitaryPanel();
    }

    @Override
    public void showReportNavalPanel() {
        this.canvas.showReportNavalPanel();
    }

    @Override
    public void showReportProductionPanel() {
        this.canvas.showReportProductionPanel();
    }

    @Override
    public void showReportReligiousPanel() {
        this.canvas.showReportReligiousPanel();
    }

    @Override
    public void showReportRequirementsPanel() {
        this.canvas.showReportRequirementsPanel();
    }

    @Override
    public void showReportTradePanel() {
        this.canvas.showReportTradePanel();
    }

    @Override
    public void showReportTurnPanel(List<ModelMessage> messages) {
        this.canvas.showReportTurnPanel(messages);
    }

    @Override
    public File showSaveDialog(File directory, String defaultName) {
        return this.canvas.showSaveDialog(directory, null, defaultName);
    }

    public File showSaveDialog(File directory, FileFilter[] fileFilters, String defaultName) {
        return this.canvas.showSaveDialog(directory, fileFilters, defaultName);
    }

    @Override
    public Dimension showScaleMapSizeDialog() {
        return this.canvas.showScaleMapSizeDialog();
    }

    @Override
    public int showSelectAmountDialog(GoodsType goodsType, int available, int defaultAmount, boolean needToPay) {
        return this.canvas.showSelectAmountDialog(goodsType, available, defaultAmount, needToPay);
    }

    @Override
    public int showSelectTributeAmountDialog(StringTemplate question, int maximum) {
        return this.canvas.showSelectTributeAmountDialog(question, maximum);
    }

    @Override
    public Location showSelectDestinationDialog(Unit unit) {
        return this.canvas.showSelectDestinationDialog(unit);
    }

    public void showServerListPanel(List<ServerInfo> serverList) {
        this.canvas.showServerListPanel(serverList);
    }

    @Override
    public void showStartGamePanel(Game game, Player player, boolean singlePlayerMode) {
        this.canvas.showStartGamePanel(game, player, singlePlayerMode);
    }

    @Override
    public void showStatisticsPanel() {
        this.canvas.showStatisticsPanel();
    }

    @Override
    public void showStatusPanel(String message) {
        this.canvas.showStatusPanel(message);
    }

    public void showTilePanel(Tile tile) {
        this.canvas.showTilePanel(tile);
    }

    @Override
    public void showTilePopUpAtSelectedTile() {
        Tile tile = this.mapViewer.getSelectedTile();
        Point point = this.mapViewer.calculateTilePosition(tile);
        this.canvas.showTilePopup(tile, point.x + this.mapViewer.getTileWidth(), point.y);
    }

    @Override
    public void showTradeRoutePanel(Unit unit) {
        this.canvas.showTradeRoutePanel(unit);
    }

    public void showTradeRouteInputPanel(TradeRoute newRoute, Runnable callBack) {
        this.canvas.showTradeRouteInputPanel(newRoute, callBack);
    }

    public void showTrainPanel() {
        this.canvas.showTrainPanel();
    }

    @Override
    public void showVictoryDialog(DialogHandler<Boolean> handler) {
        this.canvas.showVictoryDialog(handler);
    }

    public boolean showWarehouseDialog(Colony colony) {
        return this.canvas.showWarehouseDialog(colony);
    }

    public void showWorkProductionPanel(Unit unit) {
        this.canvas.showWorkProductionPanel(unit);
    }

    public void updateEuropeanSubpanels() {
        this.canvas.updateEuropeanSubpanels();
    }

    @Override
    public void updateGameOptions() {
        this.canvas.updateGameOptions();
    }

    @Override
    public void updateMapGeneratorOptions() {
        this.canvas.updateMapGeneratorOptions();
    }

    @Override
    public void centerActiveUnit() {
        this.mapViewer.centerActiveUnit();
    }

    @Override
    public void changeViewMode(int newViewMode) {
        this.mapViewer.changeViewMode(newViewMode);
    }

    public Point calculateUnitLabelPositionInTile(int labelWidth, int labelHeight, Point tileP) {
        return this.mapViewer.calculateUnitLabelPositionInTile(labelWidth, labelHeight, tileP);
    }

    public void executeWithUnitOutForAnimation(Unit unit, Tile sourceTile, OutForAnimationCallback r) {
        this.mapViewer.executeWithUnitOutForAnimation(unit, sourceTile, r);
    }

    @Override
    public Unit getActiveUnit() {
        return this.mapViewer == null ? null : this.mapViewer.getActiveUnit();
    }

    @Override
    public Tile getFocus() {
        return this.mapViewer.getFocus();
    }

    public float getMapScale() {
        return this.mapViewer.getImageLibrary().getScaleFactor();
    }

    @Override
    public Tile getSelectedTile() {
        return this.mapViewer.getSelectedTile();
    }

    public Rectangle getTileBounds(Tile tile) {
        return this.mapViewer.calculateTileBounds(tile);
    }

    public Point getTilePosition(Tile tile) {
        return this.mapViewer.calculateTilePosition(tile);
    }

    @Override
    public int getViewMode() {
        return this.mapViewer.getViewMode();
    }

    @Override
    public void setFocus(Tile tileToFocus) {
        this.mapViewer.setFocus(tileToFocus);
        this.canvas.refresh();
    }

    public void setFocusImmediately(Tile tileToFocus) {
        this.mapViewer.setFocus(tileToFocus);
        Dimension size = this.canvas.getSize();
        this.canvas.paintImmediately(0, 0, size.width, size.height);
    }

    @Override
    public boolean setSelectedTile(Tile newTileToSelect) {
        boolean result = this.mapViewer.setSelectedTile(newTileToSelect);
        this.updateMapControls();
        this.updateMenuBar();
        return result;
    }

    @Override
    public void toggleViewMode() {
        this.mapViewer.toggleViewMode();
    }

    public static BufferedImage createTileImageWithOverlayAndForest(TileType type, Dimension size) {
        return TileViewer.createTileImageWithOverlayAndForest(type, size);
    }

    public BufferedImage createTileImageWithBeachBorderAndItems(Tile tile) {
        return this.tileViewer.createTileImageWithBeachBorderAndItems(tile);
    }

    public BufferedImage createTileImage(Tile tile) {
        return this.tileViewer.createTileImage(tile);
    }

    public BufferedImage createColonyTileImage(Tile tile, Colony colony) {
        return this.tileViewer.createColonyTileImage(tile, colony);
    }

    public void displayColonyTiles(Graphics2D g, Tile[][] tiles, Colony colony) {
        this.tileViewer.displayColonyTiles(g, tiles, colony);
    }
}

