/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggesters;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public final class SuggestParseElement
implements SearchParseElement {
    private Suggesters suggesters;

    @Inject
    public SuggestParseElement(Suggesters suggesters) {
        this.suggesters = suggesters;
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        SuggestionSearchContext suggestionSearchContext = this.parseInternal(parser, context.mapperService(), context.queryParserService(), context.shardTarget().index(), context.shardTarget().shardId(), context);
        context.suggest(suggestionSearchContext);
    }

    public SuggestionSearchContext parseInternal(XContentParser parser, MapperService mapperService, IndexQueryParserService queryParserService, String index, int shardId, HasContextAndHeaders headersContext) throws IOException {
        XContentParser.Token token;
        SuggestionSearchContext suggestionSearchContext = new SuggestionSearchContext();
        BytesRef globalText = null;
        String fieldName = null;
        HashMap suggestionContexts = Maps.newHashMap();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("text".equals(fieldName)) {
                    globalText = parser.utf8Bytes();
                    continue;
                }
                throw new IllegalArgumentException("[suggest] does not support [" + fieldName + "]");
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String suggestionName = fieldName;
            BytesRef suggestText = null;
            SuggestionSearchContext.SuggestionContext suggestionContext = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if ("text".equals(fieldName)) {
                        suggestText = parser.utf8Bytes();
                        continue;
                    }
                    throw new IllegalArgumentException("[suggest] does not support [" + fieldName + "]");
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if (suggestionName == null) {
                    throw new IllegalArgumentException("Suggestion must have name");
                }
                if (this.suggesters.get(fieldName) == null) {
                    throw new IllegalArgumentException("Suggester[" + fieldName + "] not supported");
                }
                SuggestContextParser contextParser = this.suggesters.get(fieldName).getContextParser();
                suggestionContext = contextParser.parse(parser, mapperService, queryParserService, headersContext);
            }
            if (suggestionContext == null) continue;
            suggestionContext.setText(suggestText);
            suggestionContexts.put(suggestionName, suggestionContext);
        }
        for (Map.Entry entry : suggestionContexts.entrySet()) {
            String suggestionName = (String)entry.getKey();
            SuggestionSearchContext.SuggestionContext suggestionContext = (SuggestionSearchContext.SuggestionContext)entry.getValue();
            suggestionContext.setShard(shardId);
            suggestionContext.setIndex(index);
            SuggestUtils.verifySuggestion(mapperService, globalText, suggestionContext);
            suggestionSearchContext.addSuggestion(suggestionName, suggestionContext);
        }
        return suggestionSearchContext;
    }
}

