/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.profile.InternalProfileShardResults;
import org.elasticsearch.search.profile.ProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;

public class InternalSearchResponse
implements Streamable,
ToXContent {
    private InternalSearchHits hits;
    private InternalAggregations aggregations;
    private Suggest suggest;
    private InternalProfileShardResults profileResults;
    private boolean timedOut;
    private Boolean terminatedEarly = null;

    public static InternalSearchResponse empty() {
        return new InternalSearchResponse(InternalSearchHits.empty(), null, null, null, false, null);
    }

    private InternalSearchResponse() {
    }

    public InternalSearchResponse(InternalSearchHits hits, InternalAggregations aggregations, Suggest suggest, InternalProfileShardResults profileResults, boolean timedOut, Boolean terminatedEarly) {
        this.hits = hits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
    }

    public boolean timedOut() {
        return this.timedOut;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public Aggregations aggregations() {
        return this.aggregations;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public Map<String, List<ProfileShardResult>> profile() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.hits.toXContent(builder, params);
        if (this.aggregations != null) {
            this.aggregations.toXContent(builder, params);
        }
        if (this.suggest != null) {
            this.suggest.toXContent(builder, params);
        }
        if (this.profileResults != null) {
            this.profileResults.toXContent(builder, params);
        }
        return builder;
    }

    public static InternalSearchResponse readInternalSearchResponse(StreamInput in) throws IOException {
        InternalSearchResponse response = new InternalSearchResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.hits = InternalSearchHits.readSearchHits(in);
        if (in.readBoolean()) {
            this.aggregations = InternalAggregations.readAggregations(in);
        }
        if (in.readBoolean()) {
            this.suggest = Suggest.readSuggest(Suggest.Fields.SUGGEST, in);
        }
        this.timedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        this.profileResults = in.getVersion().onOrAfter(Version.V_2_2_0) && in.readBoolean() ? new InternalProfileShardResults(in) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.hits.writeTo(out);
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.timedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            if (this.profileResults == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.profileResults.writeTo(out);
            }
        }
    }
}

