/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.Store;

public class StoreModule
extends AbstractModule {
    private final ShardLock lock;
    private final Store.OnClose closeCallback;
    private final ShardPath path;
    private final Class<? extends DirectoryService> shardDirectory;

    public StoreModule(Class<? extends DirectoryService> shardDirectory, ShardLock lock, Store.OnClose closeCallback, ShardPath path) {
        this.shardDirectory = shardDirectory;
        this.lock = lock;
        this.closeCallback = closeCallback;
        this.path = path;
    }

    @Override
    protected void configure() {
        this.bind(DirectoryService.class).to(this.shardDirectory).asEagerSingleton();
        this.bind(Store.class).asEagerSingleton();
        this.bind(ShardLock.class).toInstance(this.lock);
        this.bind(Store.OnClose.class).toInstance(this.closeCallback);
        this.bind(ShardPath.class).toInstance(this.path);
    }
}

