/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class RoutingTableValidation
implements Streamable {
    private boolean valid = true;
    private List<String> failures;
    private Map<String, List<String>> indicesFailures;

    public boolean valid() {
        return this.valid;
    }

    public List<String> allFailures() {
        if (this.failures().isEmpty() && this.indicesFailures().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> allFailures = new ArrayList<String>(this.failures());
        for (Map.Entry<String, List<String>> entry : this.indicesFailures().entrySet()) {
            for (String failure : entry.getValue()) {
                allFailures.add("Index [" + entry.getKey() + "]: " + failure);
            }
        }
        return allFailures;
    }

    public List<String> failures() {
        if (this.failures == null) {
            return Collections.emptyList();
        }
        return this.failures;
    }

    public Map<String, List<String>> indicesFailures() {
        if (this.indicesFailures == null) {
            return ImmutableMap.of();
        }
        return this.indicesFailures;
    }

    public List<String> indexFailures(String index) {
        if (this.indicesFailures == null) {
            return Collections.emptyList();
        }
        List<String> indexFailures = this.indicesFailures.get(index);
        if (indexFailures == null) {
            return Collections.emptyList();
        }
        return indexFailures;
    }

    public void addFailure(String failure) {
        this.valid = false;
        if (this.failures == null) {
            this.failures = new ArrayList<String>();
        }
        this.failures.add(failure);
    }

    public void addIndexFailure(String index, String failure) {
        List<String> indexFailures;
        this.valid = false;
        if (this.indicesFailures == null) {
            this.indicesFailures = Maps.newHashMap();
        }
        if ((indexFailures = this.indicesFailures.get(index)) == null) {
            indexFailures = new ArrayList<String>();
            this.indicesFailures.put(index, indexFailures);
        }
        indexFailures.add(failure);
    }

    public String toString() {
        return this.allFailures().toString();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.valid = in.readBoolean();
        int size = in.readVInt();
        if (size == 0) {
            this.failures = Collections.emptyList();
        } else {
            this.failures = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                this.failures.add(in.readString());
            }
        }
        size = in.readVInt();
        if (size == 0) {
            this.indicesFailures = ImmutableMap.of();
        } else {
            this.indicesFailures = Maps.newHashMap();
            for (i = 0; i < size; ++i) {
                String index = in.readString();
                int size2 = in.readVInt();
                ArrayList<String> indexFailures = new ArrayList<String>(size2);
                for (int j = 0; j < size2; ++j) {
                    indexFailures.add(in.readString());
                }
                this.indicesFailures.put(index, indexFailures);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.valid);
        if (this.failures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.failures.size());
            for (String string : this.failures) {
                out.writeString(string);
            }
        }
        if (this.indicesFailures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indicesFailures.size());
            for (Map.Entry entry : this.indicesFailures.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeVInt(((List)entry.getValue()).size());
                for (String failure : (List)entry.getValue()) {
                    out.writeString(failure);
                }
            }
        }
    }
}

