/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportNodesSnapshotsStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSnapshotsStatusAction
extends TransportMasterNodeAction<SnapshotsStatusRequest, SnapshotsStatusResponse> {
    private final SnapshotsService snapshotsService;
    private final TransportNodesSnapshotsStatus transportNodesSnapshotsStatus;

    @Inject
    public TransportSnapshotsStatusAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, TransportNodesSnapshotsStatus transportNodesSnapshotsStatus, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/status", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, SnapshotsStatusRequest.class);
        this.snapshotsService = snapshotsService;
        this.transportNodesSnapshotsStatus = transportNodesSnapshotsStatus;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected ClusterBlockException checkBlock(SnapshotsStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected SnapshotsStatusResponse newResponse() {
        return new SnapshotsStatusResponse();
    }

    @Override
    protected void masterOperation(final SnapshotsStatusRequest request, ClusterState state, final ActionListener<SnapshotsStatusResponse> listener) throws Exception {
        List<SnapshotsInProgress.Entry> currentSnapshots = this.snapshotsService.currentSnapshots(request.repository(), request.snapshots());
        if (currentSnapshots.isEmpty()) {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
            return;
        }
        HashSet nodesIds = Sets.newHashSet();
        for (SnapshotsInProgress.Entry entry : currentSnapshots) {
            for (SnapshotsInProgress.ShardSnapshotStatus status : entry.shards().values()) {
                if (status.nodeId() == null) continue;
                nodesIds.add(status.nodeId());
            }
        }
        if (!nodesIds.isEmpty()) {
            SnapshotId[] snapshotIds = new SnapshotId[currentSnapshots.size()];
            for (int i = 0; i < currentSnapshots.size(); ++i) {
                snapshotIds[i] = currentSnapshots.get(i).snapshotId();
            }
            TransportNodesSnapshotsStatus.Request nodesRequest = (TransportNodesSnapshotsStatus.Request)new TransportNodesSnapshotsStatus.Request(request, nodesIds.toArray(new String[nodesIds.size()])).snapshotIds(snapshotIds).timeout(request.masterNodeTimeout());
            this.transportNodesSnapshotsStatus.execute(nodesRequest, new ActionListener<TransportNodesSnapshotsStatus.NodesSnapshotStatus>(){

                @Override
                public void onResponse(TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) {
                    try {
                        List<SnapshotsInProgress.Entry> currentSnapshots = TransportSnapshotsStatusAction.this.snapshotsService.currentSnapshots(request.repository(), request.snapshots());
                        listener.onResponse(TransportSnapshotsStatusAction.this.buildResponse(request, currentSnapshots, nodeSnapshotStatuses));
                    }
                    catch (Throwable e) {
                        listener.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    listener.onFailure(e);
                }
            });
        } else {
            listener.onResponse(this.buildResponse(request, currentSnapshots, null));
        }
    }

    private SnapshotsStatusResponse buildResponse(SnapshotsStatusRequest request, List<SnapshotsInProgress.Entry> currentSnapshots, TransportNodesSnapshotsStatus.NodesSnapshotStatus nodeSnapshotStatuses) throws IOException {
        ArrayList<SnapshotStatus> builder = new ArrayList<SnapshotStatus>();
        HashSet currentSnapshotIds = Sets.newHashSet();
        if (!currentSnapshots.isEmpty()) {
            Map<Object, Object> nodeSnapshotStatusMap = nodeSnapshotStatuses != null ? nodeSnapshotStatuses.getNodesMap() : Maps.newHashMap();
            for (SnapshotsInProgress.Entry entry : currentSnapshots) {
                currentSnapshotIds.add(entry.snapshotId());
                ArrayList<Object> shardStatusBuilder = new ArrayList<Object>();
                for (Map.Entry shardEntry : entry.shards().entrySet()) {
                    SnapshotIndexShardStage stage;
                    Object shardStatus;
                    ImmutableMap shardStatues;
                    TransportNodesSnapshotsStatus.NodeSnapshotStatus nodeStatus;
                    SnapshotsInProgress.ShardSnapshotStatus status = (SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue();
                    if (status.nodeId() != null && (nodeStatus = (TransportNodesSnapshotsStatus.NodeSnapshotStatus)nodeSnapshotStatusMap.get(status.nodeId())) != null && (shardStatues = (ImmutableMap)nodeStatus.status().get((Object)entry.snapshotId())) != null && (shardStatus = (SnapshotIndexShardStatus)shardStatues.get(shardEntry.getKey())) != null) {
                        shardStatusBuilder.add(shardStatus);
                        continue;
                    }
                    switch (((SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue()).state()) {
                        case FAILED: 
                        case ABORTED: 
                        case MISSING: {
                            stage = SnapshotIndexShardStage.FAILURE;
                            break;
                        }
                        case INIT: 
                        case WAITING: 
                        case STARTED: {
                            stage = SnapshotIndexShardStage.STARTED;
                            break;
                        }
                        case SUCCESS: {
                            stage = SnapshotIndexShardStage.DONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)((SnapshotsInProgress.ShardSnapshotStatus)shardEntry.getValue()).state()));
                        }
                    }
                    SnapshotIndexShardStatus shardStatus2 = new SnapshotIndexShardStatus((ShardId)shardEntry.getKey(), stage);
                    shardStatusBuilder.add(shardStatus2);
                }
                builder.add(new SnapshotStatus(entry.snapshotId(), entry.state(), Collections.unmodifiableList(shardStatusBuilder)));
            }
        }
        if (Strings.hasText(request.repository()) && request.snapshots() != null && request.snapshots().length > 0) {
            for (String snapshotName : request.snapshots()) {
                SnapshotsInProgress.State state;
                SnapshotId snapshotId = new SnapshotId(request.repository(), snapshotName);
                if (currentSnapshotIds.contains(snapshotId)) continue;
                Snapshot snapshot = this.snapshotsService.snapshot(snapshotId);
                ArrayList<SnapshotIndexShardStatus> shardStatusBuilder = new ArrayList<SnapshotIndexShardStatus>();
                if (!snapshot.state().completed()) continue;
                ImmutableMap<ShardId, IndexShardSnapshotStatus> shardStatues = this.snapshotsService.snapshotShards(snapshotId);
                for (Object shardStatus : shardStatues.entrySet()) {
                    shardStatusBuilder.add(new SnapshotIndexShardStatus((ShardId)shardStatus.getKey(), (IndexShardSnapshotStatus)shardStatus.getValue()));
                }
                switch (snapshot.state()) {
                    case FAILED: {
                        state = SnapshotsInProgress.State.FAILED;
                        break;
                    }
                    case SUCCESS: 
                    case PARTIAL: {
                        state = SnapshotsInProgress.State.SUCCESS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown snapshot state " + (Object)((Object)snapshot.state()));
                    }
                }
                builder.add(new SnapshotStatus(snapshotId, state, Collections.unmodifiableList(shardStatusBuilder)));
            }
        }
        return new SnapshotsStatusResponse(Collections.unmodifiableList(builder));
    }
}

