/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;

public abstract class AbstractExtensions
extends PluginObject
implements IExtensions {
    protected String fSchemaVersion;
    protected ArrayList fExtensions = new ArrayList(1);
    protected ArrayList fExtensionPoints = new ArrayList(1);

    public void add(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.fExtensions.add(extension);
        ((PluginExtension)extension).setInTheModel(true);
        ((PluginExtension)extension).setParent(this);
        this.fireStructureChanged(extension, 1);
    }

    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.fExtensionPoints.add(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(true);
        ((PluginExtensionPoint)extensionPoint).setParent(this);
        this.fireStructureChanged(extensionPoint, 1);
    }

    public IPluginExtensionPoint[] getExtensionPoints() {
        return this.fExtensionPoints.toArray(new IPluginExtensionPoint[this.fExtensionPoints.size()]);
    }

    public IPluginExtension[] getExtensions() {
        return this.fExtensions.toArray(new IPluginExtension[this.fExtensions.size()]);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("extension_order")) {
            this.swap((IPluginExtension)oldValue, (IPluginExtension)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void load(IExtensions srcExtensions) {
        this.addArrayToVector(this.fExtensions, srcExtensions.getExtensions());
        this.addArrayToVector(this.fExtensionPoints, srcExtensions.getExtensionPoints());
    }

    protected void addArrayToVector(ArrayList vector, Object[] array) {
        int i = 0;
        while (i < array.length) {
            Object obj = array[i];
            if (obj instanceof PluginObject) {
                ((PluginObject)obj).setParent(this);
            }
            vector.add(obj);
            ++i;
        }
    }

    protected void processChild(Node child) {
        String name = child.getNodeName();
        if (name.equals("extension")) {
            PluginExtension extension = new PluginExtension();
            extension.setModel(this.getModel());
            extension.setParent(this);
            this.fExtensions.add(extension);
            extension.setInTheModel(true);
            extension.load(child);
        } else if (name.equals("extension-point")) {
            PluginExtensionPoint point = new PluginExtensionPoint();
            point.setModel(this.getModel());
            point.setParent(this);
            point.setInTheModel(true);
            this.fExtensionPoints.add(point);
            point.load(child);
        }
    }

    public void remove(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.fExtensions.remove(extension);
        ((PluginExtension)extension).setInTheModel(false);
        this.fireStructureChanged(extension, 2);
    }

    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.fExtensionPoints.remove(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(false);
        this.fireStructureChanged(extensionPoint, 2);
    }

    public void reset() {
        this.fExtensions = new ArrayList();
        this.fExtensionPoints = new ArrayList();
    }

    public int getExtensionCount() {
        return this.fExtensions.size();
    }

    public int getIndexOf(IPluginExtension e) {
        return this.fExtensions.indexOf(e);
    }

    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.fExtensions.indexOf(e1);
        int index2 = this.fExtensions.indexOf(e2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECoreMessages.AbstractExtensions_extensionsNotFoundException);
        }
        this.fExtensions.set(index2, e1);
        this.fExtensions.set(index2, e2);
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    protected void writeChildren(String indent, String tag, Object[] children, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<" + tag + ">");
        int i = 0;
        while (i < children.length) {
            IPluginObject obj = (IPluginObject)children[i];
            obj.write(String.valueOf(indent) + "   ", writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "</" + tag + ">");
    }

    protected boolean hasRequiredAttributes() {
        int i = 0;
        while (i < this.fExtensions.size()) {
            IPluginExtension extension = (IPluginExtension)this.fExtensions.get(i);
            if (!extension.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.fExtensionPoints.size()) {
            IPluginExtensionPoint expoint = (IPluginExtensionPoint)this.fExtensionPoints.get(i);
            if (!expoint.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getSchemaVersion() {
        return this.fSchemaVersion;
    }

    public void setSchemaVersion(String schemaVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.fSchemaVersion;
        this.fSchemaVersion = schemaVersion;
        this.firePropertyChanged("schema-version", oldValue, schemaVersion);
    }
}

