/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class EditOutputFolderAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IJavaProject fJavaProject;
    private IJavaElement fSelectedElement;

    public EditOutputFolderAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_label, JavaPluginImages.DESC_ELCL_CONFIGURE_OUTPUT_FOLDER);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_OUTPUT_FOLDER);
        this.fSite = site;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            boolean removeProjectFromClasspath;
            IPath newDefaultOutputLocation;
            Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : JavaPlugin.getActiveWorkbenchShell();
            final List classpathEntries = ClasspathModifier.getExistingEntries(this.fJavaProject);
            IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(this.fSelectedElement.getPath(), this.fJavaProject, 3);
            CPListElement selElement = CPListElement.createFromExisting(entry, this.fJavaProject);
            final CPListElement element = ClasspathModifier.getClasspathEntry(classpathEntries, selElement);
            int index = classpathEntries.indexOf(element);
            final OutputLocationDialog dialog = new OutputLocationDialog(shell, element, classpathEntries);
            if (dialog.open() != 0) {
                return;
            }
            classpathEntries.add(index, element);
            IPath defaultOutputLocation = this.fJavaProject.getOutputLocation().makeRelative();
            if (defaultOutputLocation.segmentCount() == 1) {
                ClasspathModifierQueries.OutputFolderValidator outputFolderValidator = new ClasspathModifierQueries.OutputFolderValidator(null, this.fJavaProject){

                    public boolean validate(IPath outputLocation) {
                        return true;
                    }
                };
                ClasspathModifierQueries.OutputFolderQuery outputFolderQuery = ClasspathModifierQueries.getDefaultFolderQuery(shell, defaultOutputLocation);
                if (!outputFolderQuery.doQuery(true, outputFolderValidator, this.fJavaProject)) return;
                newDefaultOutputLocation = outputFolderQuery.getOutputLocation();
                removeProjectFromClasspath = outputFolderQuery.removeProjectFromClasspath();
            } else {
                removeProjectFromClasspath = false;
                newDefaultOutputLocation = defaultOutputLocation;
            }
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            EditOutputFolderAction.this.setOutputLocation(element, dialog.getOutputLocation(), classpathEntries, newDefaultOutputLocation, removeProjectFromClasspath, monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
                return;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.showExceptionDialog((CoreException)e.getCause());
                    return;
                }
                JavaPlugin.log(e);
                return;
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
        catch (CoreException e) {
            this.showExceptionDialog(e);
        }
    }

    private void setOutputLocation(CPListElement entry, IPath outputLocation, List existingEntries, IPath defaultOutputLocation, boolean removeProjectFromClasspath, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.EditOutputFolderAction_ProgressMonitorDescription, 4);
            if (!defaultOutputLocation.equals((Object)this.fJavaProject.getOutputLocation().makeRelative())) {
                this.fJavaProject.setOutputLocation(defaultOutputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            if (removeProjectFromClasspath) {
                ClasspathModifier.removeFromClasspath(this.fJavaProject, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            if (outputLocation != null) {
                ClasspathModifier.exclude(outputLocation, existingEntries, new ArrayList(), this.fJavaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                entry.setAttribute("output", outputLocation);
            } else {
                monitor.worked(1);
            }
            ClasspathModifier.commitClassPath(existingEntries, this.fJavaProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    public boolean canHandle(IStructuredSelection elements) {
        if (elements.size() != 1) {
            return false;
        }
        Object element = elements.getFirstElement();
        try {
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                this.fJavaProject = root.getJavaProject();
                this.fSelectedElement = root;
                return root.getKind() == 1;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return false;
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.EditOutputFolderAction_ErrorDescription, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }
}

