/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class CommonLayoutActionGroup
extends MultiActionGroup {
    private IExtensionStateModel fStateModel;
    private StructuredViewer fStructuredViewer;
    private boolean fHasContributedToViewMenu = false;
    private IAction fHierarchicalLayout = null;
    private IAction fFlatLayoutAction = null;
    private IAction[] actions;

    public CommonLayoutActionGroup(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        this.fStateModel = stateModel;
        this.fStructuredViewer = structuredViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (!this.fHasContributedToViewMenu) {
            CommonLayoutActionGroup commonLayoutActionGroup = this;
            synchronized (commonLayoutActionGroup) {
                if (!this.fHasContributedToViewMenu) {
                    this.fHasContributedToViewMenu = true;
                    this.contributeToViewMenu(actionBars.getMenuManager());
                }
            }
        }
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(PackagesMessages.LayoutActionGroup_label);
        Separator marker = new Separator("layout");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    private IAction[] createActions() {
        this.fFlatLayoutAction = new CommonLayoutAction(true);
        this.fFlatLayoutAction.setText(PackagesMessages.LayoutActionGroup_flatLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fFlatLayoutAction, "flatLayout.gif");
        this.fHierarchicalLayout = new CommonLayoutAction(false);
        this.fHierarchicalLayout.setText(PackagesMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        JavaPluginImages.setLocalImageDescriptors(this.fHierarchicalLayout, "hierarchicalLayout.gif");
        return new IAction[]{this.fFlatLayoutAction, this.fHierarchicalLayout};
    }

    public void setFlatLayout(boolean flatLayout) {
        if (this.actions == null) {
            this.actions = this.createActions();
            this.setActions(this.actions, flatLayout ? 0 : 1);
        }
        this.fHierarchicalLayout.setChecked(!flatLayout);
        this.fFlatLayoutAction.setChecked(flatLayout);
    }

    private class CommonLayoutAction
    extends Action
    implements IAction {
        private final boolean fIsFlatLayout;

        public CommonLayoutAction(boolean flat) {
            super("", 8);
            this.fIsFlatLayout = flat;
            if (this.fIsFlatLayout) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.layout_hierarchical_action");
            }
        }

        public void run() {
            if (CommonLayoutActionGroup.this.fStateModel.getBooleanProperty("isLayoutFlat") != this.fIsFlatLayout) {
                CommonLayoutActionGroup.this.fStateModel.setBooleanProperty("isLayoutFlat", this.fIsFlatLayout);
                CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(false);
                try {
                    CommonLayoutActionGroup.this.fStructuredViewer.refresh();
                }
                finally {
                    CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

