/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.Java50Fix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.dialogs.IDialogSettings;

public class Java50CleanUp
extends AbstractCleanUp {
    public static final int ADD_DEPRECATED_ANNOTATION = 1;
    public static final int ADD_OVERRIDE_ANNOATION = 2;
    public static final int ADD_TYPE_PARAMETERS_TO_RAW_TYPE_REFERENCE = 8;
    private static final int DEFAULT_FLAG = 3;
    private static final String SECTION_NAME = "CleanUp_Java50";

    public Java50CleanUp(int flag) {
        super(flag);
    }

    public Java50CleanUp(IDialogSettings settings) {
        super(Java50CleanUp.getSection(settings, SECTION_NAME), 3);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return Java50Fix.createCleanUp(compilationUnit, this.isFlag(2), this.isFlag(1), this.isFlag(8));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return Java50Fix.createCleanUp(compilationUnit, problems, this.isFlag(2), this.isFlag(1), this.isFlag(8));
    }

    public Map getRequiredOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>();
        if (this.isFlag(2)) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "warning");
        }
        if (this.isFlag(1)) {
            options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        }
        if (this.isFlag(8)) {
            options.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        }
        return options;
    }

    public void saveSettings(IDialogSettings settings) {
        super.saveSettings(Java50CleanUp.getSection(settings, SECTION_NAME));
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isFlag(2)) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description);
        }
        if (this.isFlag(1)) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingDeprecated_description);
        }
        if (this.isFlag(8)) {
            result.add(MultiFixMessages.Java50CleanUp_AddTypeParameters_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E {\n");
        buf.append("    /**\n");
        buf.append("     * @deprecated\n");
        buf.append("     */\n");
        if (this.isFlag(1)) {
            buf.append("    @Deprecated\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        buf.append("class ESub extends E {\n");
        if (this.isFlag(2)) {
            buf.append("    @Override\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        Java50Fix fix;
        if (this.isFlag(2) && (fix = Java50Fix.createAddOverrideAnnotationFix(compilationUnit, problem)) != null) {
            return true;
        }
        if (this.isFlag(1) && (fix = Java50Fix.createAddDeprectatedAnnotation(compilationUnit, problem)) != null) {
            return true;
        }
        return this.isFlag(8) && (fix = Java50Fix.createRawTypeReferenceFix(compilationUnit, problem)) != null;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isFlag(2)) {
            result += this.getNumberOfProblems(problems, 67109491);
        }
        if (this.isFlag(1)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 536871540 || id == 536871541 || id == 536871542) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isFlag(8)) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 16777748 || id == 16777788 || id == 16777747) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public int getDefaultFlag() {
        return 3;
    }
}

