/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.LocalFileStorageEditorInput;
import org.eclipse.jdt.internal.debug.ui.ZipEntryStorageEditorInput;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointFieldLocator;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointMethodLocator;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private static final String EMPTY_STRING = "";

    public ToggleBreakpointAdapter() {
        ActionDelegateHelper.getDefault();
    }

    protected void report(final String message, final IWorkbenchPart part) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    JDIDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return type;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, final boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                if (ToggleBreakpointAdapter.this.isInterface(selection)) {
                    ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_6, part);
                    return Status.OK_STATUS;
                }
                ITextEditor editor = ToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor != null && selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ToggleBreakpointAdapter.this.report(null, part);
                    ITextSelection textSelection = (ITextSelection)selection;
                    IType type = ToggleBreakpointAdapter.this.getType(textSelection);
                    int lineNumber = textSelection.getStartLine() + 1;
                    int offset = textSelection.getOffset();
                    try {
                        IClassFile classFile;
                        IEditorInput editorInput = editor.getEditorInput();
                        IDocumentProvider documentProvider = editor.getDocumentProvider();
                        if (documentProvider == null) {
                            return Status.CANCEL_STATUS;
                        }
                        IDocument document = documentProvider.getDocument((Object)editorInput);
                        if (type == null && (classFile = (IClassFile)editorInput.getAdapter(IClassFile.class)) != null && (type = classFile.getType()).getDeclaringType() != null) {
                            ISourceRange sourceRange = type.getSourceRange();
                            int start = sourceRange.getOffset();
                            int end = start + sourceRange.getLength();
                            if (offset < start || offset > end) {
                                final ITextEditor finalEditor = editor;
                                final IType finalType = type;
                                WorkbenchJob errorJob = new WorkbenchJob("Breakpoint Error Notification"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        IStatusLineManager statusLine = finalEditor.getEditorSite().getActionBars().getStatusLineManager();
                                        statusLine.setErrorMessage(MessageFormat.format((String)ActionMessages.ManageBreakpointRulerAction_Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor___0___1, (Object[])new String[]{finalType.getTypeQualifiedName()}));
                                        Display.getCurrent().beep();
                                        return Status.OK_STATUS;
                                    }
                                };
                                errorJob.schedule();
                                return Status.OK_STATUS;
                            }
                        }
                        String typeName = null;
                        IResource resource = null;
                        HashMap attributes = new HashMap(10);
                        if (type == null) {
                            resource = ToggleBreakpointAdapter.getResource((IEditorPart)editor);
                            CompilationUnit unit = ToggleBreakpointAdapter.this.parseCompilationUnit(editor);
                            for (TypeDeclaration declaration : unit.types()) {
                                int begin = declaration.getStartPosition();
                                int end = begin + declaration.getLength();
                                if (offset < begin || offset > end || declaration.isInterface()) continue;
                                typeName = ValidBreakpointLocationLocator.computeTypeName((ASTNode)declaration);
                                break;
                            }
                        } else {
                            typeName = type.getFullyQualifiedName();
                            int index = typeName.indexOf(36);
                            if (index >= 0) {
                                typeName = typeName.substring(0, index);
                            }
                            resource = BreakpointUtils.getBreakpointResource((IMember)type);
                            try {
                                IRegion line = document.getLineInformation(lineNumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, start, end);
                            }
                            catch (BadLocationException ble) {
                                JDIDebugUIPlugin.log(ble);
                            }
                        }
                        if (typeName != null && resource != null) {
                            IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)resource, (String)typeName, (int)lineNumber);
                            if (existingBreakpoint != null) {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            ToggleBreakpointAdapter.this.createLineBreakpoint(resource, typeName, lineNumber, -1, -1, 0, true, attributes, document, bestMatch, type, (IEditorPart)editor);
                        }
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void createLineBreakpoint(IResource resource, String typeName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, IDocument document, boolean bestMatch, IType type, IEditorPart editorPart) throws CoreException {
        IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
        new BreakpointLocationVerifierJob(document, breakpoint, lineNumber, bestMatch, typeName, type, resource, editorPart).schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    public void toggleMethodBreakpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Method Breakpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (ToggleBreakpointAdapter.this.isInterface(finalSelection)) {
                    ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_7, part);
                    return Status.OK_STATUS;
                }
                try {
                    ToggleBreakpointAdapter.this.report(null, part);
                    ISelection selection = finalSelection;
                    selection = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                    ITextEditor textEditor = ToggleBreakpointAdapter.this.getTextEditor(part);
                    if (textEditor != null && selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        CompilationUnit compilationUnit = ToggleBreakpointAdapter.this.parseCompilationUnit(textEditor);
                        if (compilationUnit != null) {
                            BreakpointMethodLocator locator = new BreakpointMethodLocator(textSelection.getOffset());
                            compilationUnit.accept((ASTVisitor)locator);
                            String methodName = locator.getMethodName();
                            if (methodName == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_CantAdd, part);
                                return Status.OK_STATUS;
                            }
                            String typeName = locator.getTypeName();
                            String methodSignature = locator.getMethodSignature();
                            if (methodSignature == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
                                return Status.OK_STATUS;
                            }
                            IJavaMethodBreakpoint existing = ToggleBreakpointAdapter.this.getMethodBreakpoint(typeName, methodName, methodSignature);
                            if (existing == null) {
                                ToggleBreakpointAdapter.this.createMethodBreakpoint(ToggleBreakpointAdapter.getResource((IEditorPart)part), typeName, methodName, methodSignature, true, false, false, -1, -1, -1, 0, true, new HashMap(10));
                            } else {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existing, true);
                            }
                        }
                    } else if (selection instanceof IStructuredSelection) {
                        IMethod[] members = ToggleBreakpointAdapter.this.getMethods((IStructuredSelection)selection);
                        if (members.length == 0) {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_9, part);
                            return Status.OK_STATUS;
                        }
                        int i = 0;
                        int length = members.length;
                        while (i < length) {
                            IMethod method = members[i];
                            IJavaBreakpoint breakpoint = ToggleBreakpointAdapter.this.getMethodBreakpoint((IMember)method);
                            if (breakpoint == null) {
                                int start = -1;
                                int end = -1;
                                ISourceRange range = method.getNameRange();
                                if (range != null) {
                                    start = range.getOffset();
                                    end = start + range.getLength();
                                }
                                HashMap attributes = new HashMap(10);
                                BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
                                IType type = method.getDeclaringType();
                                String methodSignature = method.getSignature();
                                String methodName = method.getElementName();
                                if (method.isConstructor()) {
                                    methodName = "<init>";
                                    if (type.isEnum()) {
                                        methodSignature = "(Ljava.lang.String;I" + methodSignature.substring(1);
                                    }
                                }
                                if (!type.isBinary() && (methodSignature = ToggleBreakpointAdapter.resolveMethodSignature(type, methodSignature)) == null) {
                                    ToggleBreakpointAdapter.this.report(ActionMessages.ManageMethodBreakpointActionDelegate_methodNonAvailable, part);
                                    return Status.OK_STATUS;
                                }
                                ToggleBreakpointAdapter.this.createMethodBreakpoint(BreakpointUtils.getBreakpointResource((IMember)method), type.getFullyQualifiedName(), methodName, methodSignature, true, false, false, -1, start, end, 0, true, attributes);
                            } else {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)breakpoint, true);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IJavaMethodBreakpoint getMethodBreakpoint(String typeName, String methodName, String methodSignature) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaMethodBreakpoint methodBreakpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaMethodBreakpoint && typeName.equals((methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getTypeName()) && methodName.equals(methodBreakpoint.getMethodName()) && methodSignature.equals(methodBreakpoint.getMethodSignature())) {
                return methodBreakpoint;
            }
            ++i;
        }
        return null;
    }

    private void removeBreakpoint(IBreakpoint breakpoint, boolean delete) throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, delete);
    }

    private void createMethodBreakpoint(IResource resource, String typeName, String methodName, String methodSignature, boolean entry, boolean exit, boolean nativeOnly, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)typeName, (String)methodName, (String)methodSignature, (boolean)entry, (boolean)exit, (boolean)nativeOnly, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection;
    }

    protected boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IJavaElement javaElement = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
            return javaElement == null || !javaElement.getJavaProject().getProject().exists();
        }
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            IJavaElement element2 = (IJavaElement)input.getAdapter(IJavaElement.class);
            if (element2 == null) {
                if (input instanceof LocalFileStorageEditorInput || input instanceof ZipEntryStorageEditorInput) {
                    return false;
                }
                ILocationProvider provider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
                return provider == null || provider.getPath((Object)input) == null;
            }
            return false;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    protected IMethod[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IMethod[0];
        }
        ArrayList<IMethod> methods = new ArrayList<IMethod>(selection.size());
        for (Object thing : selection) {
            try {
                IMethod method;
                if (!(thing instanceof IMethod) || Flags.isAbstract((int)(method = (IMethod)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (JavaModelException javaModelException) {}
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected List getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList fields = new ArrayList(selection.size());
        for (Object thing : selection) {
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IJavaFieldVariable)) continue;
            IField field = this.getField((IJavaFieldVariable)thing);
            if (field == null) {
                fields.add(thing);
                continue;
            }
            fields.add(field);
        }
        return fields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isInterface(ISelection selection) {
        if (selection.isEmpty()) return false;
        try {
            if (!(selection instanceof IStructuredSelection)) {
                if (!(selection instanceof ITextSelection)) return false;
                ITextSelection tsel = (ITextSelection)selection;
                IType type = this.getType(tsel);
                if (type == null) return false;
                if (!type.isInterface()) return false;
                return true;
            }
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            IType type = null;
            Object obj = null;
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                obj = iterator.next();
                if (!(obj instanceof IMember)) continue;
                type = ((IMember)obj).getDeclaringType();
            } while (type == null || !type.isInterface());
            return true;
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
        }
        return false;
    }

    private boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object thing : selection) {
                if (thing instanceof IField || thing instanceof IJavaFieldVariable) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void toggleWatchpoints(final IWorkbenchPart part, final ISelection finalSelection) {
        Job job = new Job("Toggle Watchpoints"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (ToggleBreakpointAdapter.this.isInterface(finalSelection)) {
                    ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_5, part);
                    return Status.OK_STATUS;
                }
                try {
                    ToggleBreakpointAdapter.this.report(null, part);
                    ISelection selection = finalSelection;
                    selection = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                    ITextEditor textEditor = ToggleBreakpointAdapter.this.getTextEditor(part);
                    boolean allowed = false;
                    if (textEditor != null && selection instanceof ITextSelection) {
                        ITextSelection textSelection = (ITextSelection)selection;
                        CompilationUnit compilationUnit = ToggleBreakpointAdapter.this.parseCompilationUnit(textEditor);
                        if (compilationUnit != null) {
                            String typeName;
                            IJavaWatchpoint existing;
                            BreakpointFieldLocator locator = new BreakpointFieldLocator(textSelection.getOffset());
                            compilationUnit.accept((ASTVisitor)locator);
                            String fieldName = locator.getFieldName();
                            if (fieldName == null) {
                                ToggleBreakpointAdapter.this.report(ActionMessages.ManageWatchpointActionDelegate_CantAdd, part);
                                return Status.OK_STATUS;
                            }
                            int idx = fieldName.indexOf("final");
                            if (idx <= -1 & !(fieldName.indexOf("static") > -1 & idx > -1)) {
                                allowed = true;
                            }
                            if ((existing = ToggleBreakpointAdapter.this.getWatchpoint(typeName = locator.getTypeName(), fieldName)) == null) {
                                if (!allowed) {
                                    ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_8, part);
                                    return Status.OK_STATUS;
                                }
                                ToggleBreakpointAdapter.this.createWatchpoint(ToggleBreakpointAdapter.getResource((IEditorPart)part), typeName, fieldName, -1, -1, -1, 0, true, new HashMap(10));
                            } else {
                                ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)existing, true);
                            }
                        }
                    } else if (selection instanceof IStructuredSelection) {
                        List fields = ToggleBreakpointAdapter.this.getFields((IStructuredSelection)selection);
                        if (fields.isEmpty()) {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_10, part);
                            return Status.OK_STATUS;
                        }
                        for (Object element : fields) {
                            IField javaField = null;
                            IJavaFieldVariable var = null;
                            String typeName = null;
                            String fieldName = null;
                            if (element instanceof IField) {
                                javaField = (IField)element;
                                typeName = javaField.getDeclaringType().getFullyQualifiedName();
                                fieldName = javaField.getElementName();
                                int f = javaField.getFlags();
                                boolean fin = Flags.isFinal((int)f);
                                allowed = !fin & !(Flags.isStatic((int)f) & fin);
                            } else if (element instanceof IJavaFieldVariable) {
                                var = (IJavaFieldVariable)element;
                                typeName = var.getDeclaringType().getName();
                                fieldName = var.getName();
                                allowed = !var.isFinal() && !var.isStatic();
                            }
                            IJavaWatchpoint breakpoint = ToggleBreakpointAdapter.this.getWatchpoint(typeName, fieldName);
                            if (breakpoint == null) {
                                if (!allowed) {
                                    ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_8, part);
                                    return Status.OK_STATUS;
                                }
                                IWorkspaceRoot resource = null;
                                int start = -1;
                                int end = -1;
                                HashMap attributes = new HashMap(10);
                                if (javaField == null) {
                                    Object object;
                                    if (var != null && (object = JavaDebugUtils.resolveSourceElement((Object)var.getJavaType(), (ILaunch)var.getLaunch())) instanceof IAdaptable) {
                                        IAdaptable adaptable = (IAdaptable)object;
                                        resource = (IResource)adaptable.getAdapter(IResource.class);
                                    }
                                    if (resource == null) {
                                        resource = ResourcesPlugin.getWorkspace().getRoot();
                                    }
                                } else {
                                    IType type = javaField.getDeclaringType();
                                    ISourceRange range = javaField.getNameRange();
                                    if (range != null) {
                                        start = range.getOffset();
                                        end = start + range.getLength();
                                    }
                                    BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)javaField);
                                    resource = BreakpointUtils.getBreakpointResource((IMember)type);
                                }
                                ToggleBreakpointAdapter.this.createWatchpoint((IResource)resource, typeName, fieldName, -1, start, end, 0, true, attributes);
                                continue;
                            }
                            ToggleBreakpointAdapter.this.removeBreakpoint((IBreakpoint)breakpoint, true);
                        }
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private IJavaWatchpoint getWatchpoint(String typeName, String fieldName) throws CoreException {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaWatchpoint watchpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaWatchpoint && typeName.equals((watchpoint = (IJavaWatchpoint)breakpoint).getTypeName()) && fieldName.equals(watchpoint.getFieldName())) {
                return watchpoint;
            }
            ++i;
        }
        return null;
    }

    private void createWatchpoint(IResource resource, String typeName, String fieldName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        JDIDebugModel.createWatchpoint((IResource)resource, (String)typeName, (String)fieldName, (int)lineNumber, (int)charStart, (int)charEnd, (int)hitCount, (boolean)register, (Map)attributes);
    }

    public static String resolveMethodSignature(IType type, String methodSignature) throws JavaModelException {
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        int length = parameterTypes.length;
        String[] resolvedParameterTypes = new String[length];
        int i = 0;
        while (i < length) {
            resolvedParameterTypes[i] = ToggleBreakpointAdapter.resolveType(type, parameterTypes[i]);
            if (resolvedParameterTypes[i] == null) {
                return null;
            }
            ++i;
        }
        String resolvedReturnType = ToggleBreakpointAdapter.resolveType(type, Signature.getReturnType((String)methodSignature));
        if (resolvedReturnType == null) {
            return null;
        }
        return Signature.createMethodSignature((String[])resolvedParameterTypes, (String)resolvedReturnType);
    }

    private static String resolveType(IType type, String typeSignature) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeSignature);
        String elementTypeSignature = Signature.getElementType((String)typeSignature);
        if (elementTypeSignature.length() == 1) {
            return typeSignature;
        }
        String elementTypeName = Signature.toString((String)elementTypeSignature);
        String[][] resolvedElementTypeNames = type.resolveType(elementTypeName);
        if (resolvedElementTypeNames == null || resolvedElementTypeNames.length != 1) {
            ITypeParameter[] typeParameters = type.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                ITypeParameter parameter = typeParameters[i];
                if (parameter.getElementName().equals(elementTypeName)) {
                    String[] bounds = parameter.getBounds();
                    if (bounds.length == 0) {
                        return "Ljava/lang/Object;";
                    }
                    String bound = Signature.createTypeSignature((String)bounds[0], (boolean)false);
                    return ToggleBreakpointAdapter.resolveType(type, bound);
                }
                ++i;
            }
            return null;
        }
        String[] types = resolvedElementTypeNames[0];
        types[1] = types[1].replace('.', '$');
        String resolvedElementTypeName = Signature.toQualifiedName((String[])types);
        String resolvedElementTypeSignature = EMPTY_STRING;
        if (types[0].equals(EMPTY_STRING)) {
            resolvedElementTypeName = resolvedElementTypeName.substring(1);
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true);
        } else {
            resolvedElementTypeSignature = Signature.createTypeSignature((String)resolvedElementTypeName, (boolean)true).replace('.', '/');
        }
        return Signature.createArraySignature((String)resolvedElementTypeSignature, (int)count);
    }

    protected static IResource getResource(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        IResource resource = (IResource)editorInput.getAdapter(IFile.class);
        if (resource == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected IMethod getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IJavaElement element = (IJavaElement)editorPart.getEditorInput().getAdapter(IJavaElement.class);
        IType type = null;
        if (element instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getMethod(methodName, sigs);
        }
        return null;
    }

    protected IJavaBreakpoint getMethodBreakpoint(IMember element) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMember container = null;
                    try {
                        container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        return null;
                    }
                    if (container == null) {
                        try {
                            if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && method.getSignature().equals(methodBreakpoint.getMethodSignature())) {
                                return methodBreakpoint;
                            }
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                    } else if (container instanceof IMethod && method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container)) {
                        return methodBreakpoint;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected CompilationUnit parseCompilationUnit(ITextEditor editor) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        return (CompilationUnit)parser.createAST(null);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            IMember m = null;
            IClassFile classFile = (IClassFile)editorInput.getAdapter(IClassFile.class);
            if (classFile != null) {
                IJavaElement e = classFile.getElementAt(offset);
                if (e instanceof IMember) {
                    m = (IMember)e;
                }
            } else {
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(editorInput);
                if (unit != null) {
                    ICompilationUnit iCompilationUnit = unit;
                    synchronized (iCompilationUnit) {
                        unit.reconcile(0, false, null, null);
                    }
                    IJavaElement e = unit.getElementAt(offset);
                    if (e instanceof IMember) {
                        m = (IMember)e;
                    }
                }
            }
            if (m != null) {
                return new StructuredSelection((Object)m);
            }
        }
        return selection;
    }

    private IField getField(IJavaFieldVariable variable) throws CoreException {
        IField field;
        String varName = null;
        try {
            varName = variable.getName();
        }
        catch (DebugException x) {
            JDIDebugUIPlugin.log(x);
            return null;
        }
        IJavaType declaringType = variable.getDeclaringType();
        IType type = JavaDebugUtils.resolveType((IJavaType)declaringType);
        if (type != null && (field = type.getField(varName)).exists()) {
            return field;
        }
        return null;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(part, selection);
    }
}

