/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Deployer;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardHostDeployer;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.valves.ErrorDispatcherValve;

public class StandardHost
extends ContainerBase
implements Deployer,
Host {
    private String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = true;
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private Deployer deployer = new StandardHostDeployer(this);
    private boolean deployXML = true;
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean liveDeploy = true;
    private String mapperClass = "org.apache.catalina.core.StandardHostMapper";
    private boolean unpackWARs = true;
    private String workDir = null;
    private DefaultContext defaultContext;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
    }

    public String getAppBase() {
        return this.appBase;
    }

    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public void addDefaultContext(DefaultContext defaultContext) {
        DefaultContext oldDefaultContext = this.defaultContext;
        this.defaultContext = defaultContext;
        this.support.firePropertyChange("defaultContext", oldDefaultContext, this.defaultContext);
    }

    public DefaultContext getDefaultContext() {
        return this.defaultContext;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.liveDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        boolean oldLiveDeploy = this.liveDeploy;
        this.liveDeploy = liveDeploy;
        this.support.firePropertyChange("liveDeploy", oldLiveDeploy, this.liveDeploy);
    }

    public String getMapperClass() {
        return this.mapperClass;
    }

    public void setMapperClass(String mapperClass) {
        String oldMapperClass = this.mapperClass;
        this.mapperClass = mapperClass;
        this.support.firePropertyChange("mapperClass", oldMapperClass, this.mapperClass);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        name = name.toLowerCase();
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public void installDefaultContext(Context context) {
        if (this.defaultContext != null && this.defaultContext instanceof StandardDefaultContext) {
            ((StandardDefaultContext)this.defaultContext).installDefaultContext(context);
        }
    }

    public void importDefaultContext(Context context) {
        if (this.defaultContext != null) {
            this.defaultContext.importDefaultContext(context);
        }
    }

    public void addAlias(String alias) {
        alias = alias.toLowerCase();
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    public String[] findAliases() {
        return this.aliases;
    }

    public String getInfo() {
        return info;
    }

    public Context map(String uri) {
        int slash;
        if (this.debug > 0) {
            this.log("Mapping request URI '" + uri + "'");
        }
        if (uri == null) {
            return null;
        }
        if (this.debug > 1) {
            this.log("  Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (this.debug > 1) {
                this.log("  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            this.log(sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (this.debug > 0) {
            this.log(" Mapped to context '" + context.getPath() + "'");
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String alias) {
        alias = alias.toLowerCase();
        String[] stringArray = this.aliases;
        synchronized (this.aliases) {
            int n = -1;
            for (int i = 0; i < this.aliases.length; ++i) {
                if (!this.aliases[i].equals(alias)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            int j = 0;
            String[] results = new String[this.aliases.length - 1];
            for (int i = 0; i < this.aliases.length; ++i) {
                if (i == n) continue;
                results[j++] = this.aliases[i];
            }
            this.aliases = results;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.fireContainerEvent("removeAlias", alias);
            return;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public synchronized void start() throws LifecycleException {
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                this.addValve(valve);
            }
            catch (Throwable t) {
                this.log(sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass));
            }
        }
        this.addValve(new ErrorDispatcherValve());
        super.start();
    }

    public void install(String contextPath, URL war) throws IOException {
        this.deployer.install(contextPath, war);
    }

    public synchronized void install(URL config, URL war) throws IOException {
        this.deployer.install(config, war);
    }

    public Context findDeployedApp(String contextPath) {
        return this.deployer.findDeployedApp(contextPath);
    }

    public String[] findDeployedApps() {
        return this.deployer.findDeployedApps();
    }

    public void remove(String contextPath) throws IOException {
        this.deployer.remove(contextPath);
    }

    public void remove(String contextPath, boolean undeploy) throws IOException {
        this.deployer.remove(contextPath, undeploy);
    }

    public void start(String contextPath) throws IOException {
        this.deployer.start(contextPath);
    }

    public void stop(String contextPath) throws IOException {
        this.deployer.stop(contextPath);
    }

    protected void addDefaultMapper(String mapperClass) {
        super.addDefaultMapper(this.mapperClass);
    }
}

