/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import java.io.File;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

public class NewConnectionWizard {
	private static final ResourceLoader resource = ResourceLoader.INSTANCE;

	public static final int ALIAS_CONNECTION_TYPE = 1;

	public static final int JDBC_CONNECTION_TYPE = 2;

	public static final int JNDI_CONNECTION_TYPE = 3;

	public final static int DEFAULT_OPTIONS = 0;

	public final static int SHOW_EXISTING_CONS = 1;

	public final static int DISABLE_DB = 2;

	public final static int DISABLE_CURRENT_USERID_PWD = 4;

	public final static int DISABLE_VENDOR_TYPE = 8;

	public final static int DISABLE_DRIVER = 16;

	public final static int SELECT_EXISTING = 32;

	public final static int SHOW_JNDI_DATASOURCES = 64;

	public final static int SHOW_ADD_ALIASES = 128;

	public final static int SHOW_COMBINED_FILTERS = 256;

	public final static int SHOW_CALLING_PAGE = 512;

	public static final String STORE_USE_OS_UID_PWD = "NewConnectionWizard.STORE_USE_OS_UID_PWD"; //$NON-NLS-1$

	public static final String STORE_USERIDS = "NewConnectionWizard.STORE_USERIDS"; //$NON-NLS-1$

	//    public static final String STORE_CONNECTION_TYPE =
	// "NewConnectionWizard.STORE_CONNECTION_TYPE";
	//    public static final String STORE_NEW_CONNECTION_NAMES =
	// "NewConnectionWizard.STORE_NEW_CONNECTION_NAMES";
	//    public static final String STORE_ALIAS_NAMES =
	// "NewConnectionWizard.STORE_ALIAS_NAMES";
	//    public static final String STORE_DATABASE_NAMES =
	// "NewConnectionWizard.STORE_DATABASE_NAMES";
	//    public static final String STORE_DATABASE_VENDOR_TYPE =
	// "NewConnectionWizard.STORE_DATABASE_VENDOR_TYPE";
	//    public static final String STORE_JDBC_DRIVER =
	// "NewConnectionWizard.STORE_JDBC_DRIVER";
	//    public static final String STORE_HOST_VALUES =
	// "NewConnectionWizard.STORE_HOST_VALUES";
	//    public static final String STORE_PORT_NUMBERS =
	// "NewConnectionWizard.STORE_PORT_NUMBERS";
	//    public static final String STORE_SERVER_NAMES =
	// "NewConnectionWizard.STORE_SERVER_NAMES";
	//    public static final String STORE_DATABASE_LOCATIONS =
	// "NewConnectionWizard.STORE_DBLOCATION_NAMES";
	//    public static final String STORE_JDBC_CLASSES =
	// "NewConnectionWizard.STORE_JDBC_CLASSES";
	//    public static final String STORE_CLASS_LOCATIONS =
	// "NewConnectionWizard.STORE_CLASS_LOCATIONS";
	//    public static final String STORE_CONNECTIONS_URL =
	// "NewConnectionWizard.STORE_CONNECTIONS_URL";
	//    public static final String STORE_SHOW_EXISTING_CONNECTIONS =
	// "NewConnectionWizard.STORE_SHOW_EXISTING_CONNECTIONS";
	//    public static final String STORE_SCHEMA_FILTERS =
	// "NewConnectionWizard.STORE_SCHEMA_FILTERS";
	//    public static final String STORE_TABLE_FILTERS =
	// "NewConnectionWizard.STORE_TABLE_FILTERS";
	//    public static final String STORE_ROUTINE_FILTERS =
	// "NewConnectionWizard.STORE_ROUTINE_FILTERS";
	//    public static final String STORE_JAVA_HOME_DIRS =
	// "NewConnectionWizard.STORE_JAVA_HOME_DIRS";
	//    public static final String STORE_SQLSCHEMA_IDS =
	// "NewConnectionWizard.STORE_SQLSCHEMA_IDS";
	//    public static final String STORE_PACKAGE_OWNERS =
	// "NewConnectionWizard.STORE_PACKAGE_OWNERS";
	//    public static final String STORE_BUILD_OWNERS =
	// "NewConnectionWizard.STORE_BUILD_OWNERS";
	//    public static final String STORE_INITIAL_CONTEXT_FACTORY =
	// "NewConnectionWizard.STORE_INITIAL_CONTEXT_FACTORY";
	//    public static final String STORE_URL_PROVIDER =
	// "NewConnectionWizard.STORE_URL_PROVIDER";
	//    public static final String STORE_JNDI_NAME =
	// "NewConnectionWizard.STORE_JNDI_NAME";


	private static int OPTIONS = DEFAULT_OPTIONS;

	public static String[] fExtensions = new String[] { "*.jar;*.zip", "*.*" }; //$NON-NLS-1$ //$NON-NLS-2$
	private static String FILE_SEPARATOR = java.io.File.pathSeparator; //$NON-NLS-1$
	

	/**
	 * @param key -
	 *            The key
	 * @return the matching resource from the properties file
	 */
	public static String getResourceString(String key) {
		return resource.queryString(key);
	}

	

	public static RSCCoreUIWidgetFactory getUIFactory() {
		return RSCCoreUIWidgetFactory.INSTANCE;
	}

	
	/**
	 * Helper to open the file chooser dialog to select multiple files.
	 * 
	 * @param wizard
	 *            An instance of ourself, so we can get our shell.
	 * @param fExtensions
	 *            An array of file extensions
	 */
	public static String getFile(Wizard wizard, String[] fExtensions) {
		StringBuffer result = new StringBuffer();
		FileDialog dialog = new FileDialog(wizard.getShell(), SWT.MULTI);
		if (fExtensions != null) {
			dialog.setFilterExtensions(fExtensions);
		}
		dialog.open();
		String path = dialog.getFilterPath();
		String[] files = dialog.getFileNames();
		if (files != null) {
			for (int i = 0; i < files.length; i++) {
				if (result.length() > 0) {
					result.append(FILE_SEPARATOR);
				}
				result.append(path).append(File.separator).append(files[i]);
			}
		}
		return result.toString();
	}

	public static String getDirectory(Wizard wizard, String current,
			String message) {
		DirectoryDialog dialog = new DirectoryDialog(wizard.getShell(),
				SWT.SINGLE);
		dialog.setMessage(message);
		dialog.setFilterPath(current);
		return dialog.open();
	}

	/**
	 * Returns the accumulated messages of nested exceptions. Returns the class
	 * name of the exception if no message is available.
	 */
	public static String getMessages(Throwable e) {
		StringBuffer eb = new StringBuffer();
		Throwable t = (Throwable) e;
		if (t.getLocalizedMessage() != null)
			eb.append(t.getLocalizedMessage());
		else
			eb.append(t.getClass().getName());
		while (t.getCause() != null) {
			t = t.getCause();
			eb.append("; "); //$NON-NLS-1$
			if (t.getLocalizedMessage() != null)
				eb.append(t.getLocalizedMessage());
			else
				eb.append(t.getClass().getName());
		}
		return eb.toString();
	}
}