/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.util.resource;

import java.io.InputStream;
import java.util.ResourceBundle;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.rdb.connection.internal.ui.RDBConnectionUIPlugin;

public class ResourceLoader
{
	private static final RDBConnectionUIPlugin plugin = RDBConnectionUIPlugin.getDefault();
	private static final String RESOURCE_PATH = "org/eclipse/wst/rdb/connection/internal/ui/l10n/"; //$NON-NLS-1$
	private static final String IMAGE_PATH = "org/eclipse/wst/rdb/connection/internal/ui/icons/"; //$NON-NLS-1$
	private static final String UI_RESOURCES = "datatoolsConnectionUI"; //$NON-NLS-1$
	private static final String NO_RESOURCE_FOUND = "NO_RESOURCE_FOUND"; //$NON-NLS-1$

	private ResourceBundle bundle;
	
	public static final ResourceLoader INSTANCE = new ResourceLoader ();
	
	private ResourceLoader()
    {
        this.bundle = ResourceBundle.getBundle(RESOURCE_PATH + UI_RESOURCES);
    }
	
    /**
     * Client should use this query Image, as the registry will dispose the image
     * @param imagePath
     * @return the image
     */
    public Image queryImageFromRegistry (String imagePath)
    {
        imagePath = IMAGE_PATH + imagePath;
		Image image = null;
		if ((image = plugin.getImageRegistry().get(imagePath)) == null)
		{
			image = queryImage(imagePath);
			plugin.getImageRegistry().put(imagePath, image);
		}
		return image;
    }

    /**
     * It is left to the client to insert those images in the plugin ImageRegistry 
     * so Images can be properly disposed
     * @param imagePath - the path to the image to create
     * @return the image
     */
    private Image queryImage(String imagePath)
    {
        Image image = null;
        try
        {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(imagePath);
            ImageData data = new ImageData(stream);
            ImageData mask = data.getTransparencyMask();
            image = new Image(Display.getCurrent(), data, mask);
            stream.close();
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return image;
    }

    public ResourceBundle getResourceBundle ()
    {
        return this.bundle;
    }
    
    /**
     * @param stringID - the key to look for
     * @return - the localized string
     */
    public String queryString (String stringID)
    {
        try
        {
            String resource = null;
            resource = this.bundle.getString(stringID);
            return (resource);
        }
        catch (Throwable e)
        {
        	return NO_RESOURCE_FOUND;
        }
    }
}
