/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodelimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;

abstract class CSSMMNodeImpl
implements CSSMMNode {
    private List fChildNodes = null;
    private String fDescription = null;
    private Map fAttributes = null;
    private int fRefCount = 0;
    static final String ATTR_NAME = "name";
    static final String NAME_NOT_AVAILABLE = "";

    public abstract String getType();

    public String getDescription() {
        return this.fDescription;
    }

    public String getAttribute(String name) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(name);
    }

    public Iterator getChildNodes() {
        if (this.fChildNodes == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableCollection(this.fChildNodes).iterator();
    }

    public Iterator getDescendants() {
        ArrayList<CSSMMNode> descendants = new ArrayList<CSSMMNode>();
        Iterator iChild = this.getChildNodes();
        while (iChild.hasNext()) {
            CSSMMNode child = (CSSMMNode)iChild.next();
            Iterator iDescendant = child.getDescendants();
            if (iDescendant.hasNext()) {
                while (iDescendant.hasNext()) {
                    CSSMMNode descendant = (CSSMMNode)iDescendant.next();
                    if (descendants.contains(descendant)) continue;
                    descendants.add(descendant);
                }
                continue;
            }
            if (descendants.contains(child)) continue;
            descendants.add(child);
        }
        return Collections.unmodifiableCollection(descendants).iterator();
    }

    void appendChild(CSSMMNode child) {
        if (child == null) {
            return;
        }
        if (this.fChildNodes == null) {
            this.fChildNodes = new ArrayList();
        }
        if (!this.fChildNodes.contains(child)) {
            this.fChildNodes.add(child);
            ++((CSSMMNodeImpl)child).fRefCount;
        }
    }

    void removeChild(CSSMMNode child) {
        if (child == null || this.fChildNodes == null) {
            return;
        }
        Iterator i = this.fChildNodes.iterator();
        while (i.hasNext()) {
            if (i.next() != child) continue;
            i.remove();
            --((CSSMMNodeImpl)child).fRefCount;
            return;
        }
    }

    void removeAllChildNodes() {
        if (this.fChildNodes == null) {
            return;
        }
        Iterator i = this.fChildNodes.iterator();
        while (i.hasNext()) {
            --((CSSMMNodeImpl)i.next()).fRefCount;
        }
        this.fChildNodes.clear();
    }

    abstract boolean canContain(CSSMMNode var1);

    void initializeAttribute(Map attributes) throws IllegalArgumentException {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap();
        }
        this.fAttributes.putAll(attributes);
        this.postSetAttribute();
    }

    void setDescription(String description) {
        this.fDescription = description;
    }

    void postSetAttribute() throws IllegalArgumentException {
    }

    abstract short getError();

    int getChildCount() {
        return this.fChildNodes != null ? this.fChildNodes.size() : 0;
    }

    int getReferenceCount() {
        return this.fRefCount;
    }
}

