/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class BaseCommand
extends Command {
    private static final String XML = "xml";
    XSDConcreteComponent addedXSDConcreteComponent;
    IDOMNode domNode;

    public BaseCommand() {
    }

    public BaseCommand(String label) {
        super(label);
    }

    public XSDConcreteComponent getAddedComponent() {
        return this.addedXSDConcreteComponent;
    }

    protected void beginRecording(Object element) {
        if (element instanceof IDOMNode) {
            this.domNode = (IDOMNode)element;
            this.domNode.getModel().beginRecording((Object)this, this.getUndoDescription());
        }
    }

    protected void endRecording() {
        if (this.domNode != null) {
            this.domNode.getModel().endRecording((Object)this);
        }
    }

    protected String getUndoDescription() {
        return this.getLabel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void formatChild(Element child) {
        if (!(child instanceof IDOMNode)) return;
        IDOMModel model = ((IDOMNode)child).getModel();
        try {
            model.aboutToChangeModel();
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)child);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            model.changedModel();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        model.changedModel();
    }

    protected static void ensureSchemaElement(XSDSchema schema) {
        Document document = schema.getDocument();
        Element schemaElement = document.getDocumentElement();
        if (schemaElement == null) {
            String targetNamespace = BaseCommand.getDefaultNamespace(schema);
            schema.setTargetNamespace(targetNamespace);
            Map qNamePrefixToNamespaceMap = schema.getQNamePrefixToNamespaceMap();
            qNamePrefixToNamespaceMap.put("tns", targetNamespace);
            if (XSDEditorPlugin.getDefault().isQualifyXMLSchemaLanguage()) {
                String prefix = XSDEditorPlugin.getDefault().getXMLSchemaPrefix();
                schema.setSchemaForSchemaQNamePrefix(prefix);
                qNamePrefixToNamespaceMap.put(prefix, "http://www.w3.org/2001/XMLSchema");
            } else {
                qNamePrefixToNamespaceMap.put(null, "http://www.w3.org/2001/XMLSchema");
            }
            schema.updateElement();
            BaseCommand.ensureXMLDirective(document);
        }
    }

    private static void ensureXMLDirective(Document document) {
        if (BaseCommand.hasXMLDirective(document)) {
            return;
        }
        Node firstChild = document.getFirstChild();
        ProcessingInstruction xmlDeclaration = BaseCommand.getXMLDeclaration(document);
        document.insertBefore(xmlDeclaration, firstChild);
        Text textNode = document.createTextNode(System.getProperty("line.separator"));
        document.insertBefore(textNode, firstChild);
    }

    private static boolean hasXMLDirective(Document document) {
        Node firstChild = document.getFirstChild();
        if (firstChild == null) {
            return false;
        }
        if (firstChild.getNodeType() != 7) {
            return false;
        }
        ProcessingInstruction processingInstruction = (ProcessingInstruction)firstChild;
        return XML.equals(processingInstruction.getTarget());
    }

    private static ProcessingInstruction getXMLDeclaration(Document document) {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        if (charSet == null || charSet.trim().equals("")) {
            charSet = "UTF-8";
        }
        ProcessingInstruction xmlDeclaration = document.createProcessingInstruction(XML, "version=\"1.0\" encoding=\"" + charSet + "\"");
        return xmlDeclaration;
    }

    private static String getDefaultNamespace(XSDSchema schema) {
        String namespace = XSDEditorPlugin.getDefault().getXMLSchemaTargetNamespace();
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        namespace = String.valueOf(namespace) + BaseCommand.getFileName(schema) + "/";
        return namespace;
    }

    private static String getFileName(XSDSchema schema) {
        URI schemaURI = schema.eResource().getURI();
        Path filePath = new Path(schemaURI.toString());
        return filePath.removeFileExtension().lastSegment().toString();
    }
}

