/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.connection.internal.ui.wizards.other;

import java.text.MessageFormat;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public class OtherNewConnectionProvider
implements IServerConnectionUIProvider,
Listener {
    private static final RSCCoreUIWidgetFactory factory = RSCCoreUIWidgetFactory.INSTANCE;
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = resource.queryString("CUI_NEWCW_DATABASE_LBL_UI_");
    private static final String CUI_NEWCW_HOST_LBL_UI_ = resource.queryString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = resource.queryString("CUI_NEWCW_PORT_LBL_UI_");
    private static final String CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_");
    private static final String CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_");
    private static final String CUI_NEWCW_JARBROWSE_BTN_UI_ = resource.queryString("CUI_NEWCW_JARBROWSE_BTN_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = resource.queryString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_");
    private static final String CUI_NEWCW_DEFDBNAME_VAL_UI_ = resource.queryString("CUI_NEWCW_DEFDBNAME_VAL_UI_");
    private static final String CUI_NEWCW_VALIDATE_HOST_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_");
    private static final String CUI_NEWCW_VALIDATE_PORT_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_PORT_REQ_UI_");
    private static final String CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_");
    private static final String CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_");
    private static final String CUI_NEWCW_VALIDATE_URL_REQ_UI_ = resource.queryString("CUI_NEWCW_VALIDATE_URL_REQ_UI_");
    private IServerConnectionInformation connectionInformation;
    private DatabaseDefinition definition;
    private Label databaseLabel;
    private Text databaseCombo;
    private Label driverLabel;
    private Text driverDisplay;
    private Label locationLabel;
    private Text locationCombo;
    private Button browseLocation;
    private Label urlLabel;
    private Text urlDisplay;
    private WizardPage parentPage;
    private Composite parentComposite;

    private void createLayout(Composite parentComposite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        parentComposite.setLayout((Layout)layout);
    }

    public boolean determinePageCompletion() {
        return this.validateControl();
    }

    private void setConnectionInformation() {
        this.connectionInformation.setDatabaseName(this.databaseCombo.getText());
        this.connectionInformation.setURL(this.urlDisplay.getText());
        this.connectionInformation.setDriverClassName(this.driverDisplay.getText());
        this.connectionInformation.setLoadingPath(this.locationCombo.getText());
        if (this.determinePageCompletion()) {
            this.connectionInformation.setInformationComplete(true);
        }
    }

    private boolean validateControl() {
        if (this.databaseCombo.getText() == null || this.databaseCombo.getText().equals("")) {
            this.parentPage.setErrorMessage(MessageFormat.format(CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_, CUI_NEWCW_DEFDBNAME_VAL_UI_));
            return false;
        }
        if (this.driverDisplay != null && this.driverDisplay.getEnabled() && this.driverDisplay.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_);
            return false;
        }
        if (this.locationCombo != null && this.locationCombo.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_);
            return false;
        }
        if (this.urlDisplay != null && this.urlDisplay.getText().trim().length() == 0) {
            this.parentPage.setErrorMessage(CUI_NEWCW_VALIDATE_URL_REQ_UI_);
            return false;
        }
        return true;
    }

    private void addListeners() {
        this.locationCombo.addListener(24, (Listener)this);
        this.browseLocation.addListener(13, (Listener)this);
        this.databaseCombo.addListener(24, (Listener)this);
        this.driverDisplay.addListener(24, (Listener)this);
        this.urlDisplay.addListener(24, (Listener)this);
    }

    private void initialize() {
        this.addListeners();
        this.determinePageCompletion();
    }

    private void removeListeners() {
        this.locationCombo.removeListener(24, (Listener)this);
        this.browseLocation.removeListener(13, (Listener)this);
        this.databaseCombo.removeListener(24, (Listener)this);
        this.driverDisplay.removeListener(24, (Listener)this);
        this.urlDisplay.removeListener(24, (Listener)this);
    }

    private Composite createServerConnectionUI(Composite parent) {
        this.parentComposite = factory.createComposite(parent, 0);
        this.createLayout(this.parentComposite);
        this.databaseLabel = factory.createLabel(this.parentComposite, 0);
        this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.databaseLabel.setLayoutData((Object)gd);
        this.databaseCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.databaseCombo.setLayoutData((Object)gd);
        this.driverLabel = factory.createLabel(this.parentComposite, 0);
        this.driverLabel.setText(CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.driverLabel.setLayoutData((Object)gd);
        this.driverDisplay = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.driverDisplay.setLayoutData((Object)gd);
        this.locationLabel = factory.createLabel(this.parentComposite, 0);
        this.locationLabel.setText(CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.locationLabel.setLayoutData((Object)gd);
        this.locationCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.locationCombo.setLayoutData((Object)gd);
        this.browseLocation = factory.createButton(this.parentComposite, 8);
        this.browseLocation.setText(CUI_NEWCW_JARBROWSE_BTN_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.browseLocation.setLayoutData((Object)gd);
        this.urlLabel = factory.createLabel(this.parentComposite, 0);
        this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlDisplay = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.urlDisplay.setLayoutData((Object)gd);
        this.initialize();
        return this.parentComposite;
    }

    public Composite getServerConnectionUI(Composite parent) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.parentComposite = this.createServerConnectionUI(parent);
        }
        this.setConnectionInformation();
        return this.parentComposite;
    }

    public void setServerConnectionInformation(IServerConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public void setDatabaseDefinition(DatabaseDefinition definition) {
        this.definition = definition;
    }

    public void setWizardPage(WizardPage parentPage) {
        this.parentPage = parentPage;
    }

    public void handleEvent(Event event) {
        String file;
        Widget source = event.widget;
        if (source == this.databaseCombo) {
            this.connectionInformation.setDatabaseName(this.databaseCombo.getText());
        } else if (source == this.urlDisplay) {
            this.connectionInformation.setURL(this.urlDisplay.getText());
        } else if (source == this.driverDisplay) {
            this.connectionInformation.setDriverClassName(this.driverDisplay.getText());
        } else if (source == this.browseLocation && (file = NewConnectionWizard.getFile((Wizard)this.parentPage.getWizard(), NewConnectionWizard.fExtensions)) != null && file.length() > 0) {
            this.locationCombo.removeListener(24, (Listener)this);
            this.locationCombo.setText(file);
            this.locationCombo.addListener(24, (Listener)this);
            this.connectionInformation.setLoadingPath(file);
        }
        this.setConnectionInformation();
    }

    public void loadProperties() {
        this.removeListeners();
        this.urlDisplay.setText(this.connectionInformation.getURL());
        this.driverDisplay.setText(this.connectionInformation.getDriverClassName());
        this.locationCombo.setText(this.connectionInformation.getLoadingPath());
        this.databaseCombo.setText(this.connectionInformation.getDatabaseName());
        this.addListeners();
        this.setConnectionInformation();
    }
}

