/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.server.extensions.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.DDLGenerator;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.server.extensions.internal.ServerExtensionsPlugin;
import org.eclipse.wst.rdb.server.extensions.internal.actions.Action;
import org.eclipse.wst.rdb.server.extensions.internal.util.Utility;

public class OpenAction
extends Action {
    public void run(IAction action) {
        try {
            Object selectedObject;
            this.init();
            Iterator itSelection = this.selection.iterator();
            if (itSelection.hasNext() && (selectedObject = itSelection.next()) instanceof SQLObject) {
                SQLObject sqlObject = (SQLObject)selectedObject;
                DatabaseDefinition dbdef = Utility.getDBDef(this.database);
                DDLGenerator ddlGenerator = dbdef.getDDLGenerator();
                SQLObject[] elements = new SQLObject[]{sqlObject};
                EngineeringOption[] options = ddlGenerator.getOptions(elements);
                ArrayList<Boolean> optionsSettings = new ArrayList<Boolean>(options.length);
                int i = 0;
                while (i < options.length) {
                    EngineeringOption option = options[i];
                    if (option != null) {
                        optionsSettings.add(i, new Boolean(option.getBoolean()));
                        option.setBoolean(true);
                    } else {
                        optionsSettings.add(null);
                    }
                    ++i;
                }
                String[] result = ddlGenerator.createSQLObjects(elements, true, true, (IProgressMonitor)new NullProgressMonitor());
                int i2 = 0;
                while (i2 < options.length) {
                    EngineeringOption option = options[i2];
                    if (option != null) {
                        option.setBoolean(((Boolean)optionsSettings.get(i2)).booleanValue());
                    }
                    ++i2;
                }
                StringBuffer res = new StringBuffer();
                int i3 = 0;
                while (i3 < result.length) {
                    res.append(result[i3]).append("\n\n");
                    ++i3;
                }
                if (result.length > 0) {
                    this.launchSQLEditor(res.toString(), sqlObject.getName());
                }
            }
        }
        catch (Exception e) {
            ServerExtensionsPlugin.getDefault().writeLog(4, 0, e.getMessage(), e);
        }
    }

    public void launchSQLEditor(String ddl, String title) {
        this.getEditorLaunch().launchSQLEditor(ddl, Utility.getConnectionInfo(this.database), title);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action.isEnabled() && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof EObject) {
            EObject o = (EObject)((IStructuredSelection)selection).getFirstElement();
            ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
            String groupID = containmentService.getGroupId(o);
            action.setEnabled(groupID != null && groupID.startsWith("core."));
        }
    }
}

