/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;

public class RemoteResourcePropertiesDialog
extends TrayDialog {
    private ISVNRemoteResource remoteResource;
    private ISVNInfo svnInfo;
    private ISVNProperty[] properties;
    private String errorMessage;
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(75, 75, true), new ColumnWeightData(200, 200, true)};
    private String[] columnHeaders = new String[]{Policy.bind("RemoteResourcePropertiesDialog.property"), Policy.bind("RemoteResourcePropertiesDialog.value")};

    public RemoteResourcePropertiesDialog(Shell parentShell, ISVNRemoteResource remoteResource) {
        super(parentShell);
        this.remoteResource = remoteResource;
    }

    protected Control createDialogArea(Composite parent) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ISVNClientAdapter client = SVNProviderPlugin.getPlugin().getSVNClientManager().createSVNClient();
                    RemoteResourcePropertiesDialog.this.svnInfo = client.getInfo(RemoteResourcePropertiesDialog.this.remoteResource.getUrl());
                    RemoteResourcePropertiesDialog.this.properties = client.getProperties(RemoteResourcePropertiesDialog.this.remoteResource.getUrl());
                }
                catch (Exception e) {
                    RemoteResourcePropertiesDialog.this.errorMessage = e.getMessage();
                }
            }
        });
        this.getShell().setText(Policy.bind("RemoteResourcePropertiesDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        if (this.svnInfo == null) {
            Text errorText = new Text(composite, 2624);
            GridData data = new GridData();
            data.widthHint = 300;
            data.heightHint = 100;
            errorText.setLayoutData((Object)data);
            errorText.setEditable(false);
            errorText.setText(this.errorMessage);
            return composite;
        }
        Group infoGroup = new Group(composite, 0);
        infoGroup.setText(Policy.bind("RemoteResourcePropertiesDialog.info"));
        GridLayout infoLayout = new GridLayout();
        infoLayout.numColumns = 2;
        infoGroup.setLayout((Layout)infoLayout);
        GridData data = new GridData(1808);
        infoGroup.setLayoutData((Object)data);
        Label urlLabel = new Label((Composite)infoGroup, 0);
        urlLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.url"));
        Text urlText = new Text((Composite)infoGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        urlText.setLayoutData((Object)data);
        urlText.setEditable(false);
        urlText.setText(this.remoteResource.getUrl().toString());
        Label authorLabel = new Label((Composite)infoGroup, 0);
        authorLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.author"));
        Text authorText = new Text((Composite)infoGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        authorText.setLayoutData((Object)data);
        authorText.setEditable(false);
        authorText.setText(this.svnInfo.getLastCommitAuthor());
        Label revisionLabel = new Label((Composite)infoGroup, 0);
        revisionLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.revision"));
        Text revisionText = new Text((Composite)infoGroup, 2048);
        data = new GridData();
        data.widthHint = 75;
        revisionText.setLayoutData((Object)data);
        revisionText.setEditable(false);
        revisionText.setText(this.svnInfo.getLastChangedRevision().toString());
        Label dateLabel = new Label((Composite)infoGroup, 0);
        dateLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.date"));
        Text dateText = new Text((Composite)infoGroup, 2048);
        data = new GridData();
        data.widthHint = 300;
        dateText.setLayoutData((Object)data);
        dateText.setEditable(false);
        dateText.setText(this.svnInfo.getLastChangedDate().toString());
        if (this.remoteResource instanceof ISVNRemoteFile) {
            String lockOwner = null;
            try {
                lockOwner = this.svnInfo.getLockOwner();
            }
            catch (Exception exception) {}
            if (lockOwner != null) {
                Label lockOwnerLabel = new Label((Composite)infoGroup, 0);
                lockOwnerLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockOwner"));
                Text lockOwnerText = new Text((Composite)infoGroup, 2048);
                data = new GridData();
                data.widthHint = 300;
                lockOwnerText.setLayoutData((Object)data);
                lockOwnerText.setEditable(false);
                lockOwnerText.setText(this.svnInfo.getLockOwner());
            }
            Date lockCreationDate = null;
            try {
                lockCreationDate = this.svnInfo.getLockCreationDate();
            }
            catch (Exception exception) {}
            if (lockCreationDate != null) {
                Label lockCreatedLabel = new Label((Composite)infoGroup, 0);
                lockCreatedLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockCreated"));
                Text lockCreatedText = new Text((Composite)infoGroup, 2048);
                data = new GridData();
                data.widthHint = 300;
                lockCreatedText.setLayoutData((Object)data);
                lockCreatedText.setEditable(false);
                lockCreatedText.setText(this.svnInfo.getLockCreationDate().toString());
            }
            String lockComment = null;
            try {
                lockComment = this.svnInfo.getLockComment();
            }
            catch (Exception exception) {}
            if (lockComment != null) {
                Label lockCommentLabel = new Label((Composite)infoGroup, 0);
                lockCommentLabel.setText(Policy.bind("RemoteResourcePropertiesDialog.lockComment"));
                data = new GridData();
                data.horizontalSpan = 2;
                lockCommentLabel.setLayoutData((Object)data);
                Text lockCommentText = new Text((Composite)infoGroup, 2624);
                data = new GridData();
                data.widthHint = 300;
                data.heightHint = 100;
                data.horizontalSpan = 2;
                lockCommentText.setLayoutData((Object)data);
                lockCommentText.setEditable(false);
                lockCommentText.setText(this.svnInfo.getLockComment());
            }
        }
        Group propertyGroup = new Group(composite, 0);
        propertyGroup.setText(Policy.bind("RemoteResourcePropertiesDialog.properties"));
        GridLayout propertyLayout = new GridLayout();
        propertyLayout.numColumns = 1;
        propertyGroup.setLayout((Layout)propertyLayout);
        data = new GridData(1808);
        propertyGroup.setLayoutData((Object)data);
        Table table = new Table((Composite)propertyGroup, 768);
        table.setLinesVisible(true);
        TableViewer viewer = new TableViewer(table);
        viewer.setUseHashlookup(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        viewer.setContentProvider((IContentProvider)new RemoteResourceContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RemoteResourceLabelProvider());
        viewer.setInput((Object)this.remoteResource);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.remote_resource_properties_dialog_context");
        data = new GridData();
        data.widthHint = 500;
        data.heightHint = 100;
        table.setLayoutData((Object)data);
        return composite;
    }

    class RemoteResourceContentProvider
    implements IStructuredContentProvider {
        RemoteResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object arg0) {
            return RemoteResourcePropertiesDialog.this.properties;
        }
    }

    class RemoteResourceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RemoteResourceLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex >= 0 && columnIndex <= 1) {
                ISVNProperty property = (ISVNProperty)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getName();
                    }
                    case 1: {
                        return property.getValue();
                    }
                }
                return "";
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

