/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.rubypeople.rdt.internal.ui.text.HereDocPatternRule;
import org.rubypeople.rdt.internal.ui.text.NumberSignDetector;

public class RubyPartitionScanner
extends RuleBasedPartitionScanner {
    public static final String RUBY_STRING = "__ruby_string";
    public static final String RUBY_MULTI_LINE_COMMENT = "__ruby_multiline_comment";
    public static final String RUBY_SINGLE_LINE_COMMENT = "__ruby_singleline_comment";
    public static final String RUBY_REGULAR_EXPRESSION = "partition_scanner_ruby_regular_expression";
    public static final String RUBY_COMMAND = "partition_scanner_ruby_command";
    public static final String HERE_DOC = "partition_scanner_here_doc";
    public static final String[] LEGAL_CONTENT_TYPES = new String[]{"__ruby_string", "__ruby_multiline_comment", "__ruby_singleline_comment", "partition_scanner_ruby_regular_expression", "partition_scanner_ruby_command"};

    public RubyPartitionScanner() {
        this.initialize();
    }

    protected void initialize() {
        Token token = new Token((Object)RUBY_STRING);
        Token token2 = new Token((Object)RUBY_MULTI_LINE_COMMENT);
        Token token3 = new Token((Object)RUBY_SINGLE_LINE_COMMENT);
        Token token4 = new Token((Object)RUBY_REGULAR_EXPRESSION);
        Token token5 = new Token((Object)RUBY_COMMAND);
        Token token6 = new Token((Object)RUBY_STRING);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SingleLineRule("\"", "\"", (IToken)token, '\\'));
        arrayList.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        this.createGeneralDelimitedRules(arrayList, "%q", (IToken)token, '\\');
        this.createGeneralDelimitedRules(arrayList, "%Q", (IToken)token, '\\');
        this.createGeneralDelimitedRules(arrayList, "%", (IToken)token, '\\');
        this.createRuleWithOptionalEndChars(arrayList, "/", "/", new char[]{'s', 'u', 'e', 'n', 'x', 'm', 'o', 'i'}, (IToken)token4, '\\');
        arrayList.add(new SingleLineRule("/", "/", (IToken)token4, '\\'));
        this.createGeneralDelimitedRules(arrayList, "%r", (IToken)token4, '\\');
        arrayList.add(new SingleLineRule("`", "`", (IToken)token5, '\\'));
        this.createGeneralDelimitedRules(arrayList, "%x", (IToken)token5, '\\');
        arrayList.add(new WordPatternRule((IWordDetector)new NumberSignDetector(), "?", "#", Token.UNDEFINED));
        arrayList.add(new EndOfLineRule("#", (IToken)token3));
        MultiLineRule multiLineRule = new MultiLineRule("=begin", "=end", (IToken)token2);
        multiLineRule.setColumnConstraint(0);
        arrayList.add(multiLineRule);
        arrayList.add((Object)new HereDocPatternRule((IToken)token6));
        IPredicateRule[] iPredicateRuleArray = new IPredicateRule[arrayList.size()];
        arrayList.toArray(iPredicateRuleArray);
        this.setPredicateRules(iPredicateRuleArray);
    }

    private void createRuleWithOptionalEndChars(List list, String string, String string2, char[] cArray, IToken iToken, char c) {
        int n = 0;
        while (n < cArray.length) {
            list.add(new SingleLineRule(string, String.valueOf(string2) + cArray[n], iToken, c));
            ++n;
        }
    }

    private void createGeneralDelimitedRules(List list, String string, IToken iToken, char c) {
        list.add(new MultiLineRule(String.valueOf(string) + "[", "]", iToken, c));
        list.add(new MultiLineRule(String.valueOf(string) + "{", "}", iToken, c));
        list.add(new MultiLineRule(String.valueOf(string) + "(", ")", iToken, c));
        list.add(new MultiLineRule(String.valueOf(string) + "<", ">", iToken, c));
    }
}

