/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ResizableEditPolicy
extends NonResizableEditPolicy {
    private int directions = -1;

    protected List createSelectionHandles() {
        ArrayList list = new ArrayList();
        if (this.directions == 0) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        } else if (this.directions != -1) {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)this.getHost(), list);
            if ((this.directions & 0x10) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 16);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 16);
            }
            if ((this.directions & 0x14) == 20) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 20);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 20);
            }
            if ((this.directions & 4) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 4);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 4);
            }
            if ((this.directions & 0xC) == 12) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 12);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 12);
            }
            if ((this.directions & 8) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 8);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 8);
            }
            if ((this.directions & 9) == 9) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 9);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 9);
            }
            if ((this.directions & 1) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 1);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 1);
            }
            if ((this.directions & 0x11) == 17) {
                ResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 17);
            } else {
                NonResizableHandleKit.addHandle((GraphicalEditPart)this.getHost(), list, 17);
            }
        } else {
            ResizableHandleKit.addHandles((GraphicalEditPart)this.getHost(), list);
        }
        return list;
    }

    public void eraseSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public Command getCommand(Request request) {
        if ("resize".equals(request.getType())) {
            return this.getResizeCommand((ChangeBoundsRequest)request);
        }
        return super.getCommand(request);
    }

    public int getResizeDirections() {
        return this.directions;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest("resize children");
        req.setEditParts(this.getHost());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand(req);
    }

    public void setResizeDirections(int newDirections) {
        this.directions = newDirections;
    }

    public void showSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    public boolean understandsRequest(Request request) {
        if ("resize".equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }
}

