/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.bcel.classfile.Method;

public class LockChecker {
    private ClassContext classContext;
    private Method method;
    private LockDataflow lockDataflow;
    private ValueNumberDataflow vnaDataflow;
    private HashMap<Location, LockSet> cache;

    public LockChecker(ClassContext classContext, Method method) {
        this.classContext = classContext;
        this.method = method;
        this.cache = new HashMap();
    }

    public void execute() throws DataflowAnalysisException, CFGBuilderException {
        BitSet bytecodeSet = this.classContext.getBytecodeSet(this.method);
        if (bytecodeSet == null) {
            return;
        }
        if (bytecodeSet.get(194) || bytecodeSet.get(195)) {
            this.lockDataflow = this.classContext.getLockDataflow(this.method);
        } else if (this.method.isSynchronized()) {
            this.vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        }
    }

    public LockSet getFactAtLocation(Location location) throws DataflowAnalysisException {
        if (this.lockDataflow != null) {
            return this.lockDataflow.getFactAtLocation(location);
        }
        LockSet lockSet = this.cache.get(location);
        if (lockSet == null) {
            lockSet = new LockSet();
            lockSet.setDefaultLockCount(0);
            if (this.method.isSynchronized() && !this.method.isStatic()) {
                ValueNumber instance = ((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getThisValue();
                lockSet.setLockCount(instance.getNumber(), 1);
            }
            this.cache.put(location, lockSet);
        }
        return lockSet;
    }
}

