/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.templates.ITemplateEditor;
import org.epic.perleditor.templates.Template;
import org.epic.perleditor.templates.TemplateBuffer;
import org.epic.perleditor.templates.TemplateContext;
import org.epic.perleditor.templates.TemplatePosition;
import org.epic.perleditor.templates.TemplateVariable;
import org.epic.perleditor.templates.Templates;
import org.epic.perleditor.templates.textmanipulation.MultiTextEdit;
import org.epic.perleditor.templates.textmanipulation.NopTextEdit;
import org.epic.perleditor.templates.textmanipulation.SimpleTextEdit;
import org.epic.perleditor.templates.textmanipulation.TextBuffer;
import org.epic.perleditor.templates.textmanipulation.TextBufferEditor;
import org.epic.perleditor.templates.textmanipulation.TextEdit;

public abstract class ContextType
implements ITemplateEditor {
    private final String fName;
    private final Map fVariables = new HashMap();

    public ContextType(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void addVariable(TemplateVariable variable) {
        this.fVariables.put(variable.getName(), variable);
    }

    public void removeVariable(TemplateVariable variable) {
        this.fVariables.remove(variable.getName());
    }

    public void removeAllVariables() {
        this.fVariables.clear();
    }

    public Iterator variableIterator() {
        return this.fVariables.values().iterator();
    }

    public abstract TemplateContext createContext();

    public void edit(TemplateBuffer templateBuffer, TemplateContext context) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(templateBuffer.getString());
        TemplatePosition[] variables = templateBuffer.getVariables();
        MultiTextEdit positions = ContextType.variablesToPositions(variables);
        MultiTextEdit multiEdit = new MultiTextEdit();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (!variable.isResolved()) {
                String value;
                String name = variable.getName();
                int[] offsets = variable.getOffsets();
                int length = variable.getLength();
                TemplateVariable evaluator = (TemplateVariable)this.fVariables.get(name);
                String string = value = evaluator == null ? null : evaluator.evaluate(context);
                if (value != null) {
                    variable.setLength(value.length());
                    variable.setResolved(evaluator.isResolved(context));
                    int k = 0;
                    while (k != offsets.length) {
                        multiEdit.add(SimpleTextEdit.createReplace(offsets[k], length, value));
                        ++k;
                    }
                }
            }
            ++i;
        }
        TextBufferEditor editor = new TextBufferEditor(textBuffer);
        editor.add(positions);
        editor.add(multiEdit);
        editor.performEdits(null);
        ContextType.positionsToVariables(positions, variables);
        templateBuffer.setContent(textBuffer.getContent(), variables);
    }

    private static MultiTextEdit variablesToPositions(TemplatePosition[] variables) {
        MultiTextEdit positions = new MultiTextEdit();
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new NopTextEdit(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(MultiTextEdit positions, TemplatePosition[] variables) {
        Iterator iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    public Template[] getTemplates() {
        Template[] templates = Templates.getInstance().getTemplates();
        Vector<Template> vector = new Vector<Template>();
        int i = 0;
        while (i != templates.length) {
            if (templates[i].getContextTypeName().equals(this.fName)) {
                vector.add(templates[i]);
            }
            ++i;
        }
        return vector.toArray(new Template[vector.size()]);
    }
}

