/*
 * Decompiled with CFR 0.152.
 */
package org.almworks.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Log {
    private static final String DEFAULT_APPLICATION_LOGGER_NAME = "org.almworks";
    private static String ourApplicationLoggerName;
    private static Logger ourApplicationLogger;
    private static boolean ourErrorOccurred;
    private static volatile Runnable ourOutOfMemoryHandler;

    public static void error(Object object, Throwable throwable) {
        String string = object == null ? "" : (object instanceof String ? (String)object : object.toString() + " (class " + object.getClass().getName() + ") caused error");
        ourErrorOccurred = true;
        Log.getApplicationLogger().log(Log.createLogRecord(Level.SEVERE, string, throwable));
        if (Log.isOutOfMemory(throwable)) {
            Log.onOutOfMemory();
        }
    }

    public static void error(String string) {
        Log.error(string, new Throwable());
    }

    public static void error(Throwable throwable) {
        Log.error(null, throwable);
    }

    public static void warn(String string) {
        Log.warn(string, null);
    }

    public static void warn(String string, Throwable throwable) {
        Log.getApplicationLogger().log(Log.createLogRecord(Level.WARNING, string, throwable));
    }

    public static void warn(Throwable throwable) {
        Log.warn("", throwable);
    }

    public static boolean debug(String string) {
        return Log.debug(string, null);
    }

    public static boolean debug(String string, Throwable throwable) {
        Log.getApplicationLogger().log(Log.createLogRecord(Level.INFO, string, throwable));
        return true;
    }

    public static boolean debug(Throwable throwable) {
        return Log.debug(null, throwable);
    }

    public static synchronized Logger getRootLogger() {
        return Logger.getLogger("");
    }

    public static synchronized Logger getApplicationLogger() {
        if (ourApplicationLogger == null) {
            if (ourApplicationLoggerName == null) {
                ourApplicationLoggerName = DEFAULT_APPLICATION_LOGGER_NAME;
            }
            ourApplicationLogger = Logger.getLogger(DEFAULT_APPLICATION_LOGGER_NAME);
        }
        return ourApplicationLogger;
    }

    public static void installOutOfMemoryHandler(Runnable runnable) {
        ourOutOfMemoryHandler = runnable;
    }

    public static void setApplicationLoggerName(String string) {
        ourApplicationLoggerName = string;
        ourApplicationLogger = null;
    }

    public static boolean isExceptionOccured() {
        return ourErrorOccurred;
    }

    public static boolean isOutOfMemory(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof OutOfMemoryError) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static Handler[] replaceHandlers(Logger logger, Handler handler) {
        return Log.replaceHandlers(logger, new Handler[]{handler});
    }

    public static Handler[] replaceHandlers(Logger logger, Handler[] handlerArray) {
        Handler[] handlerArray2;
        for (Handler handler : handlerArray2 = logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        if (handlerArray != null) {
            for (Handler handler : handlerArray) {
                logger.addHandler(handler);
            }
        }
        return handlerArray2;
    }

    public static boolean hasHandlerOfClass(Class clazz) {
        Handler[] handlerArray;
        for (Handler handler : handlerArray = Log.getRootLogger().getHandlers()) {
            if (!clazz.isAssignableFrom(handler.getClass())) continue;
            return true;
        }
        return false;
    }

    private static LogRecord createLogRecord(Level level, String string, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        logRecord.setSourceClassName("");
        logRecord.setSourceMethodName("");
        return logRecord;
    }

    private static void onOutOfMemory() {
        Runnable runnable = ourOutOfMemoryHandler;
        if (runnable != null) {
            runnable.run();
        }
    }

    private Log() {
    }

    static {
        ourErrorOccurred = false;
        ourOutOfMemoryHandler = null;
    }
}

