/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class HideUtilityClassConstructorCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST aAST) {
        boolean hasAccessibleCtor;
        DetailAST objBlock = aAST.findFirstToken(6);
        DetailAST child = (DetailAST)objBlock.getFirstChild();
        boolean hasMethod = false;
        boolean hasNonStaticMethod = false;
        boolean hasDefaultCtor = true;
        boolean hasPublicCtor = false;
        while (child != null) {
            DetailAST modifiers;
            if (child.getType() == 9) {
                hasMethod = true;
                modifiers = child.findFirstToken(5);
                if (!modifiers.branchContains(64)) {
                    hasNonStaticMethod = true;
                }
            }
            if (child.getType() == 8) {
                hasDefaultCtor = false;
                modifiers = child.findFirstToken(5);
                if (!modifiers.branchContains(61) && !modifiers.branchContains(63)) {
                    hasPublicCtor = true;
                }
            }
            child = (DetailAST)child.getNextSibling();
        }
        boolean bl = hasAccessibleCtor = hasDefaultCtor || hasPublicCtor;
        if (hasMethod && !hasNonStaticMethod && hasAccessibleCtor) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "Utility classes should not have a public or default constructor.");
        }
    }
}

