/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public final class Utils {
    private static final Map CREATED_RES = new HashMap();

    private Utils() {
    }

    public static boolean whitespaceBefore(int aIndex, String aLine) {
        int i = 0;
        while (i < aIndex) {
            if (!Character.isWhitespace(aLine.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String aLine) {
        int len = aLine.length();
        int i = len - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(aLine.charAt(i))) break;
            --len;
            --i;
        }
        return len;
    }

    public static int lengthExpandedTabs(String aString, int aToIdx, int aTabWidth) {
        int len = 0;
        char[] chars = aString.toCharArray();
        int idx = 0;
        while (idx < aToIdx) {
            len = chars[idx] == '\t' ? (len / aTabWidth + 1) * aTabWidth : ++len;
            ++idx;
        }
        return len;
    }

    public static RE getRE(String aPattern) throws RESyntaxException {
        RE retVal = (RE)CREATED_RES.get(aPattern);
        if (retVal == null) {
            retVal = new RE(aPattern);
            CREATED_RES.put(aPattern, retVal);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLines(String aFileName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        LineNumberReader lnr = new LineNumberReader(new FileReader(aFileName));
        try {
            String l;
            while ((l = lnr.readLine()) != null) {
                lines.add(l);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                lnr.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            lnr.close();
        }
        catch (IOException e) {}
        return lines.toArray(new String[0]);
    }

    public static RE createRE(String aPattern) throws ConversionException {
        RE retVal = null;
        try {
            retVal = Utils.getRE(aPattern);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("Failed to initialise regexp expression " + aPattern, e);
        }
        return retVal;
    }

    public static String baseClassname(String aType) {
        int i = aType.lastIndexOf(".");
        return i == -1 ? aType : aType.substring(i + 1);
    }
}

