/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoResultSet;
import virtuoso.jdbc4.VirtuosoStatement;

class VirtuosoRow {
    private Vector content;
    protected int maxCol;
    private VirtuosoResultSet resultSet;

    VirtuosoRow(VirtuosoResultSet virtuosoResultSet, Vector vector) throws VirtuosoException {
        this.resultSet = virtuosoResultSet;
        this.content = vector;
        this.maxCol = virtuosoResultSet.metaData.getColumnCount();
    }

    protected void getContent(Object[] objectArray) {
        for (int i = 0; i < objectArray.length && i < this.maxCol; ++i) {
            objectArray[i] = this.content.elementAt(i);
        }
    }

    protected InputStream getAsciiStream(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        this.resultSet.wasNull(object == null);
        if (object != null && object instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)object).getAsciiStream();
        }
        try {
            if (object != null && object instanceof String) {
                return new ByteArrayInputStream(((String)object).getBytes("8859_1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new VirtuosoException(unsupportedEncodingException, -10);
        }
        if (object != null && object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        return null;
    }

    protected InputStream getBinaryStream(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        this.resultSet.wasNull(object == null);
        if (object != null && object instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)object).getBinaryStream();
        }
        try {
            if (object != null && object instanceof String) {
                return new ByteArrayInputStream(((String)object).getBytes("8859_1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new VirtuosoException(unsupportedEncodingException, -10);
        }
        if (object != null && object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        return null;
    }

    protected Reader getCharacterStream(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        this.resultSet.wasNull(object == null);
        if (object != null && object instanceof VirtuosoBlob) {
            return ((VirtuosoBlob)object).getCharacterStream();
        }
        if (object != null && object instanceof String) {
            String string = (String)object;
            VirtuosoStatement virtuosoStatement = (VirtuosoStatement)this.resultSet.getStatement();
            if (virtuosoStatement.connection.charset != null && object instanceof String) {
                int n2 = this.resultSet.metaData.getColumnDtp(n);
                switch (n2) {
                    case 181: 
                    case 182: 
                    case 238: {
                        try {
                            string = virtuosoStatement.connection.uncharsetBytes((String)object);
                            break;
                        }
                        catch (Exception exception) {
                            string = (String)object;
                        }
                    }
                }
            }
            return new StringReader(string);
        }
        if (object != null && object instanceof char[]) {
            return new CharArrayReader((char[])object);
        }
        return null;
    }

    protected BigDecimal getBigDecimal(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof Number) {
                try {
                    return new BigDecimal(((Number)object).doubleValue());
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a number.", -10);
                }
            }
            try {
                return new BigDecimal(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a number.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected boolean getBoolean(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                return ((Number)object).intValue() != 0;
            }
            if (object instanceof String) {
                return Integer.parseInt((String)object) != 0;
            }
            if (object instanceof byte[]) {
                return Integer.parseInt(new String((byte[])object)) != 0;
            }
            return new Boolean(object.toString());
        }
        this.resultSet.wasNull(true);
        return false;
    }

    protected byte getByte(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).byteValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a byte.", -10);
                }
            }
            try {
                return new Byte(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a byte.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected byte[] getBytes(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof VirtuosoBlob) {
                VirtuosoBlob virtuosoBlob = (VirtuosoBlob)object;
                if (virtuosoBlob.length() > Integer.MAX_VALUE) {
                    throw new VirtuosoException("Will not return more than 2147483647 for a BLOB column. Use getBinaryStream() instead", -12);
                }
                return virtuosoBlob.getBytes(1L, (int)virtuosoBlob.length());
            }
            if (object instanceof byte[]) {
                return (byte[])object;
            }
            if (object instanceof String) {
                try {
                    return ((String)object).getBytes("8859_1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return null;
                }
            }
            throw new VirtuosoException("getBytes() return undefined on a value of type " + object.getClass(), -12);
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected double getDouble(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).doubleValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a double.", -10);
                }
            }
            try {
                return new Double(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a double.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0.0;
    }

    protected Date getDate(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Date) {
                return Date.valueOf(((Date)object).toString());
            }
            if (object instanceof String) {
                return Date.valueOf((String)object);
            }
            return Date.valueOf(((java.util.Date)object).toString());
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Time getTime(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Time) {
                return Time.valueOf(((Time)object).toString());
            }
            if (object instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)object;
                Time time = new Time(date.getTime());
                return Time.valueOf(time.toString());
            }
            if (object instanceof String) {
                return Time.valueOf((String)object);
            }
            return null;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Timestamp getTimestamp(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Timestamp) {
                return (Timestamp)object;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                return new Timestamp(date.getTime());
            }
            if (object instanceof Time) {
                Time time = (Time)object;
                return new Timestamp(time.getTime());
            }
            if (object instanceof String) {
                Timestamp timestamp = Timestamp.valueOf((String)object);
                return timestamp;
            }
            return null;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected float getFloat(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).floatValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a float.", -10);
                }
            }
            try {
                return new Float(object.toString()).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a float.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0.0f;
    }

    protected int getInt(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).intValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain an int.", -10);
                }
            }
            try {
                return new Integer(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not an int.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected long getLong(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).longValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a long.", -10);
                }
            }
            try {
                return new Long(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a long.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0L;
    }

    protected short getShort(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (object instanceof Number) {
                try {
                    return ((Number)object).shortValue();
                }
                catch (ClassCastException classCastException) {
                    throw new VirtuosoException("Column does not contain a short.", -10);
                }
            }
            try {
                return new Short(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new VirtuosoException(object.toString() + " is not a short.", -11);
            }
        }
        this.resultSet.wasNull(true);
        return 0;
    }

    protected String getString(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            int n2 = this.resultSet.metaData.getColumnDtp(n);
            this.resultSet.wasNull(false);
            VirtuosoStatement virtuosoStatement = (VirtuosoStatement)this.resultSet.getStatement();
            if (virtuosoStatement.connection.charset != null && object instanceof String) {
                switch (n2) {
                    case 181: 
                    case 182: 
                    case 238: {
                        try {
                            return virtuosoStatement.connection.uncharsetBytes((String)object);
                        }
                        catch (Exception exception) {
                            return (String)object;
                        }
                    }
                }
            }
            if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                switch (n2) {
                    case 129: {
                        return new Date(timestamp.getTime()).toString();
                    }
                    case 210: {
                        return new Time(timestamp.getTime()).toString();
                    }
                }
            } else if (object instanceof VirtuosoBlob) {
                try {
                    int n3;
                    Reader reader = ((VirtuosoBlob)object).getCharacterStream();
                    char[] cArray = new char[1024];
                    StringWriter stringWriter = new StringWriter();
                    while ((n3 = reader.read(cArray)) != -1) {
                        stringWriter.write(cArray, 0, n3);
                    }
                    return stringWriter.toString();
                }
                catch (IOException iOException) {
                    throw new VirtuosoException(iOException, -17);
                }
            }
            return object.toString();
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected VirtuosoBlob getBlob(int n) throws VirtuosoException {
        VirtuosoBlob virtuosoBlob;
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        VirtuosoBlob virtuosoBlob2 = virtuosoBlob = this.content.elementAt(n - 1) instanceof String ? new VirtuosoBlob(((String)this.content.elementAt(n - 1)).getBytes()) : (VirtuosoBlob)this.content.elementAt(n - 1);
        if (virtuosoBlob != null) {
            this.resultSet.wasNull(false);
            return virtuosoBlob;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected VirtuosoBlob getClob(int n) throws VirtuosoException {
        VirtuosoBlob virtuosoBlob;
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        VirtuosoBlob virtuosoBlob2 = virtuosoBlob = this.content.elementAt(n - 1) instanceof String ? new VirtuosoBlob(((String)this.content.elementAt(n - 1)).getBytes()) : (VirtuosoBlob)this.content.elementAt(n - 1);
        if (virtuosoBlob != null) {
            this.resultSet.wasNull(false);
            return virtuosoBlob;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected Object createDOMT(Object object) throws VirtuosoException {
        Object[] objectArray;
        Object object2 = null;
        Method method = null;
        try {
            objectArray = Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            Method method2 = objectArray.getDeclaredMethod("newInstance", new Class[0]);
            Method method3 = objectArray.getDeclaredMethod("newDocumentBuilder", new Class[0]);
            Object object3 = method2.invoke(null, new Object[0]);
            object2 = method3.invoke(object3, new Object[0]);
            Class<?> clazz = Class.forName("javax.xml.parsers.DocumentBuilder");
            Class<?> clazz2 = Class.forName("java.io.InputStream");
            method = clazz.getDeclaredMethod("parse", clazz2);
        }
        catch (Throwable throwable) {
            object2 = null;
        }
        if (object2 == null || method == null) {
            return object;
        }
        try {
            if (object instanceof String) {
                objectArray = new Object[]{new ByteArrayInputStream(((String)object).getBytes("UTF-8"))};
                object = method.invoke(object2, objectArray);
            } else if (object instanceof VirtuosoBlob) {
                objectArray = new Object[]{((VirtuosoBlob)object).getBinaryStream()};
                object = method.invoke(object2, objectArray);
            }
        }
        catch (Exception exception) {
            throw new VirtuosoException(exception, -10);
        }
        return object;
    }

    protected Object getObject(int n) throws VirtuosoException {
        if (n < 1 || n > this.maxCol) {
            throw new VirtuosoException("Bad column number : " + n + " not in 1<n<" + this.maxCol, -4);
        }
        Object object = this.content.elementAt(n - 1);
        if (object != null) {
            this.resultSet.wasNull(false);
            if (this.resultSet.metaData.isXml(n)) {
                object = this.createDOMT(object);
            } else if (object instanceof Date) {
                object = Date.valueOf(((Date)object).toString());
            } else if (object instanceof Time) {
                object = Time.valueOf(((Time)object).toString());
            }
            return object;
        }
        this.resultSet.wasNull(true);
        return null;
    }

    protected int getRow() {
        return this.maxCol != this.content.size() ? ((Number)this.content.elementAt(this.maxCol)).intValue() : 0;
    }

    protected String getRef() {
        if (this.maxCol != this.content.size()) {
            Vector vector = (Vector)this.content.elementAt(this.maxCol);
            Vector vector2 = (Vector)vector.elementAt(1);
            Object object = vector2.elementAt(0);
            return object.toString();
        }
        return "";
    }

    protected Vector getBookmark() {
        if (this.maxCol != this.content.size()) {
            return (Vector)this.content.elementAt(this.maxCol);
        }
        return this.content;
    }

    public void finalize() throws Throwable {
        if (this.content != null) {
            this.content.removeAllElements();
            this.content = null;
        }
        this.resultSet = null;
    }

    public String toString() {
        if (this.content == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ROW ");
        stringBuffer.append(this.content.toString());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

